/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.solr;

import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.solr.model.SolrAgent;
import eu.europeana.entitymanagement.solr.model.SolrConcept;
import eu.europeana.entitymanagement.solr.model.SolrEntity;
import eu.europeana.entitymanagement.solr.model.SolrOrganization;
import eu.europeana.entitymanagement.solr.model.SolrPlace;
import eu.europeana.entitymanagement.solr.model.SolrTimeSpan;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;

public class SolrUtils {
    public static final String SOLR_AGENT_SUGGESTER_FILTER = "solrAgentFilter";
    public static final String SOLR_ORGANIZATION_SUGGESTER_FILTER = "solrOrganizationFilter";
    public static final String SOLR_TIMESPAN_SUGGESTER_FILTER = "solrTimeSpanFilter";
    public static final String SOLR_PLACE_SUGGESTER_FILTER = "solrPlaceFilter";
    public static final String SOLR_CONCEPT_SUGGESTER_FILTER = "solrConceptFilter";

    public static Map<String, List<String>> normalizeStringListMapByAddingPrefix(String fieldNamePrefix, Map<String, List<String>> languageMap) {
        if (MapUtils.isEmpty(languageMap)) {
            return new HashMap<String, List<String>>();
        }
        Map<String, List<String>> res = !languageMap.keySet().iterator().next().contains(fieldNamePrefix) ? languageMap.entrySet().stream().collect(Collectors.toMap(entry -> fieldNamePrefix + (String)entry.getKey(), Map.Entry::getValue)) : languageMap;
        return res;
    }

    public static Map<String, String> normalizeStringMapByAddingPrefix(String fieldNamePrefix, Map<String, String> languageMap) {
        if (MapUtils.isEmpty(languageMap)) {
            return new HashMap<String, String>();
        }
        Map<String, String> res = !languageMap.keySet().iterator().next().contains(fieldNamePrefix) ? languageMap.entrySet().stream().collect(Collectors.toMap(entry -> fieldNamePrefix + (String)entry.getKey(), Map.Entry::getValue)) : languageMap;
        return res;
    }

    public static <T extends Entity, U extends SolrEntity<T>> Class<U> getSolrEntityClass(String solrType) {
        if (solrType.equals(EntityTypes.Agent.getEntityType())) {
            return SolrAgent.class;
        }
        if (solrType.equals(EntityTypes.Concept.getEntityType())) {
            return SolrConcept.class;
        }
        if (solrType.equals(EntityTypes.Organization.getEntityType())) {
            return SolrOrganization.class;
        }
        if (solrType.equals(EntityTypes.Place.getEntityType())) {
            return SolrPlace.class;
        }
        if (solrType.equalsIgnoreCase(EntityTypes.TimeSpan.getEntityType())) {
            return SolrTimeSpan.class;
        }
        throw new IllegalArgumentException(String.format("Unrecognized entity type while determining Solr entity class: %s ", solrType));
    }

    public static SolrEntity<? extends Entity> createSolrEntity(EntityRecord record) {
        Entity entity = record.getEntity();
        SolrEntity solrEntity = null;
        if (entity instanceof Agent) {
            solrEntity = new SolrAgent((Agent)entity);
        } else if (entity instanceof Concept) {
            solrEntity = new SolrConcept((Concept)entity);
        } else if (entity instanceof Organization) {
            solrEntity = new SolrOrganization((Organization)entity);
        } else if (entity instanceof Place) {
            solrEntity = new SolrPlace((Place)entity);
        } else if (entity instanceof TimeSpan) {
            solrEntity = new SolrTimeSpan((TimeSpan)entity);
        }
        if (solrEntity == null) {
            throw new IllegalArgumentException(String.format("Unrecognized entity type while creating SolrEntity: %s ", entity.getClass().getName()));
        }
        SolrUtils.setMetricsAndFilters(solrEntity, record);
        return solrEntity;
    }

    private static void setMetricsAndFilters(SolrEntity<? extends Entity> solrEntity, EntityRecord record) {
        Aggregation aggregation = record.getEntity().getIsAggregatedBy();
        if (aggregation != null) {
            solrEntity.setDocCount(aggregation.getRecordCount());
            if (aggregation.getPageRank() != null) {
                solrEntity.setPageRank(Float.valueOf(aggregation.getPageRank().floatValue()));
            }
            if (aggregation.getScore() != null) {
                solrEntity.setDerivedScore(Float.valueOf(aggregation.getScore().floatValue()));
            }
        }
        if (solrEntity.getDocCount() != null && solrEntity.getDocCount() > 0) {
            solrEntity.setSuggestFilters(Arrays.asList(solrEntity.getType(), "europeana"));
        } else {
            solrEntity.setSuggestFilters(List.of(solrEntity.getType()));
        }
    }
}

