/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.mongo.repository;

import dev.morphia.Datastore;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import dev.morphia.query.updates.UpdateOperator;
import dev.morphia.query.updates.UpdateOperators;
import eu.europeana.entitymanagement.definitions.model.EntityIdGenerator;
import eu.europeana.entitymanagement.mongo.utils.MorphiaUtils;
import javax.annotation.Resource;

public abstract class AbstractRepository {
    @Resource(name="emDataStore")
    Datastore datastore;

    public long generateAutoIncrement(String type) {
        EntityIdGenerator autoIncrement = (EntityIdGenerator)this.getDataStore().find(EntityIdGenerator.class).filter(new Filter[]{Filters.eq((String)"_id", (Object)type)}).modify(UpdateOperators.inc((String)"value"), new UpdateOperator[0]).execute(MorphiaUtils.MAJORITY_WRITE_MODIFY_OPTS);
        if (autoIncrement == null) {
            autoIncrement = new EntityIdGenerator(type, 1L);
            this.getDataStore().save((Object)autoIncrement);
        }
        return autoIncrement.getValue();
    }

    public long getLastGeneratedIdentifier(String type) {
        EntityIdGenerator sequenceValue = (EntityIdGenerator)this.getDataStore().find(EntityIdGenerator.class).first();
        return sequenceValue != null ? sequenceValue.getValue() : 0L;
    }

    protected Datastore getDataStore() {
        return this.datastore;
    }
}

