/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.mongo.repository;

import dev.morphia.Datastore;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import eu.europeana.entitymanagement.definitions.model.Vocabulary;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository(value="emVocabularyRepo")
public class VocabularyRepository {
    @Resource(name="emDataStore")
    Datastore datastore;
    private static final String ID = "id";
    private List<Vocabulary> europeanaRoles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Vocabulary> getEuropeanaRoles() {
        VocabularyRepository vocabularyRepository = this;
        synchronized (vocabularyRepository) {
            if (this.europeanaRoles == null) {
                this.europeanaRoles = new ArrayList<Vocabulary>();
                this.europeanaRoles.addAll(this.datastore.find(Vocabulary.class).iterator().toList());
            }
            return this.europeanaRoles;
        }
    }

    public List<Vocabulary> findByUri(List<String> vocabularyIds) {
        return this.getEuropeanaRoles().stream().filter(el -> vocabularyIds.contains(el.getId())).toList();
    }

    public List<Vocabulary> findInDbByUri(List<String> vocabularyIds) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filters.in((String)ID, vocabularyIds));
        return this.datastore.find(Vocabulary.class).filter((Filter[])filters.toArray(Filter[]::new)).iterator().toList();
    }

    public Vocabulary save(Vocabulary vocab) {
        return (Vocabulary)this.datastore.save((Object)vocab);
    }

    public List<Vocabulary> saveBulk(List<Vocabulary> vocabs) {
        return this.datastore.save(vocabs);
    }

    public void dropCollection() {
        this.datastore.getCollection(Vocabulary.class).drop();
    }

    public long countRecords() {
        return this.datastore.find(Vocabulary.class).count();
    }
}

