/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.mongo.repository;

import com.mongodb.client.result.UpdateResult;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.experimental.updates.UpdateOperators;
import eu.europeana.entitymanagement.definitions.model.EntityIdGenerator;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.web.EntityIdDisabledStatus;
import eu.europeana.entitymanagement.mongo.repository.AbstractRepository;
import eu.europeana.entitymanagement.mongo.utils.MorphiaUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="emEntityRecordRepo")
public class EntityRecordRepository
extends AbstractRepository {
    public long count() {
        return this.getDataStore().find(EntityRecord.class).count();
    }

    public boolean existsByEntityId(String entityId) {
        return this.getDataStore().find(EntityRecord.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).count() > 0L;
    }

    public List<EntityRecord> findByEntityIds(List<String> entityIds, boolean excludeDisabled, boolean fetchFullRecord) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filters.in((String)"entityId", entityIds));
        if (excludeDisabled) {
            filters.add(Filters.eq((String)"disabled", null));
        }
        ArrayList<String> fields = new ArrayList<String>();
        if (!fetchFullRecord) {
            fields = new ArrayList();
            fields.add("entityId");
            fields.add("disabled");
        }
        return this.findEntityRecords((Filter[])filters.toArray(Filter[]::new), false, (String[])fields.toArray(String[]::new));
    }

    public EntityRecord findByEntityId(String entityId, String[] fields) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filters.eq((String)"entityId", (Object)entityId));
        List<EntityRecord> recordList = this.findEntityRecords((Filter[])filters.toArray(Filter[]::new), false, fields);
        if (recordList.isEmpty()) {
            return null;
        }
        return recordList.get(0);
    }

    protected List<EntityRecord> findEntityRecords(Filter[] filters, boolean disableValidation, String[] fields) {
        Query query = this.getDataStore().find(EntityRecord.class);
        if (disableValidation) {
            query.disableValidation();
        }
        if (filters != null && filters.length > 0) {
            query.filter(filters);
        }
        FindOptions findOptions = new FindOptions();
        if (fields != null && fields.length > 0) {
            findOptions.projection().include(fields);
        }
        return query.iterator(findOptions).toList();
    }

    public List<EntityIdDisabledStatus> getEntityIds(List<String> entityIds, boolean excludeDisabled) {
        List<EntityRecord> entityRecords = this.findByEntityIds(entityIds, excludeDisabled, false);
        return entityRecords.stream().map(entityRecord -> new EntityIdDisabledStatus(entityRecord.getEntityId(), entityRecord.isDisabled())).collect(Collectors.toList());
    }

    public long deleteForGood(String entityId) {
        return this.getDataStore().find(EntityRecord.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).delete().getDeletedCount();
    }

    public EntityRecord save(EntityRecord entityRecord) {
        return (EntityRecord)this.getDataStore().save((Object)entityRecord);
    }

    public void dropCollection() {
        this.getDataStore().getMapper().getCollection(EntityRecord.class).drop();
        this.getDataStore().getMapper().getCollection(EntityIdGenerator.class).drop();
    }

    public List<EntityRecord> findEntitiesByCoreference(List<String> uris, String entityId, boolean excludeDisabled) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filters.or((Filter[])new Filter[]{Filters.in((String)"entity.sameAs", uris), Filters.in((String)"entity.exactMatch", uris)}));
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            filters.add(Filters.ne((String)"entityId", (Object)entityId));
        }
        if (excludeDisabled) {
            filters.add(Filters.eq((String)"disabled", null));
        }
        return this.findEntityRecords((Filter[])filters.toArray(Filter[]::new), true, null);
    }

    public List<EntityRecord> findByEntityIdsOrCoreference(List<String> uris) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filters.or((Filter[])new Filter[]{Filters.in((String)"entityId", uris), Filters.in((String)"entity.sameAs", uris), Filters.in((String)"entity.exactMatch", uris)}));
        filters.add(Filters.eq((String)"disabled", null));
        return this.findEntityRecords((Filter[])filters.toArray(Filter[]::new), true, null);
    }

    public List<EntityRecord> saveBulk(List<EntityRecord> entityRecords) {
        return this.getDataStore().save(entityRecords);
    }

    public List<EntityRecord> findWithCount(int start, int count, Filter[] filters) {
        return this.getDataStore().find(EntityRecord.class).filter(filters).iterator(new FindOptions().skip(start).sort(new Sort[]{Sort.ascending((String)"modified")}).limit(count)).toList();
    }

    public List<EntityRecord> findAll(int start, int count) {
        return this.getDataStore().find(EntityRecord.class).iterator(new FindOptions().skip(start).sort(new Sort[]{Sort.ascending((String)"modified")}).limit(count)).toList();
    }

    public long deleteBulk(List<String> entityIds) {
        return this.getDataStore().find(EntityRecord.class).filter(new Filter[]{Filters.in((String)"entityId", entityIds)}).delete(MorphiaUtils.MULTI_DELETE_OPTS).getDeletedCount();
    }

    public UpdateResult disableBulk(List<String> entityIds) {
        Date disablingDate = new Date();
        return this.getDataStore().find(EntityRecord.class).filter(new Filter[]{Filters.in((String)"entityId", entityIds)}).update(UpdateOperators.set((String)"disabled", (Object)disablingDate), new UpdateOperator[0]).execute(MorphiaUtils.MULTI_UPDATE_OPTS);
    }
}

