/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.mongo.config;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.MapperOptions;
import eu.europeana.batch.entity.JobExecutionEntity;
import eu.europeana.entitymanagement.definitions.batch.codec.ScheduledTaskTypeCodec;
import eu.europeana.entitymanagement.definitions.batch.codec.ScheduledTaskTypeCodecProvider;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.codecs.pojo.PropertyCodecProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:entitymanagement.properties", "classpath:entitymanagement.user.properties"}, ignoreResourceNotFound=true)
public class DataSourceConfig {
    private static final Logger logger = LogManager.getLogger(DataSourceConfig.class);
    @Value(value="${mongo.connectionUrl}")
    private String hostUri;
    @Value(value="${mongo.max.idle.time.millisec: 10000}")
    private long mongoMaxIdleTimeMillisec;
    @Value(value="${mongo.em.database}")
    private String emDatabase;
    @Value(value="${mongo.batch.database}")
    private String batchDatabase;

    @Bean
    public MongoClient mongoClient() {
        ConnectionString connectionString = new ConnectionString(this.hostUri);
        PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().register(new PropertyCodecProvider[]{new ScheduledTaskTypeCodecProvider()}).build();
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new ScheduledTaskTypeCodec()}), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider}), MongoClientSettings.getDefaultCodecRegistry()});
        Block connectionPoolSettingsBlockBuilder = builder -> builder.maxConnectionIdleTime(this.mongoMaxIdleTimeMillisec, TimeUnit.MILLISECONDS);
        return MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(connectionString).applyToConnectionPoolSettings(connectionPoolSettingsBlockBuilder).codecRegistry(codecRegistry).build());
    }

    @Primary
    @Bean(value={"emDataStore"})
    public Datastore emDataStore(MongoClient mongoClient) {
        logger.info("Configuring Entity Management database: {}", (Object)this.emDatabase);
        Datastore datastore = Morphia.createDatastore((MongoClient)mongoClient, (String)this.emDatabase, (MapperOptions)MapperOptions.builder().mapSubPackages(true).build());
        datastore.getMapper().mapPackage("eu.europeana.entitymanagement.definitions.model");
        datastore.ensureIndexes();
        return datastore;
    }

    @Bean(name={"batchDataStore"})
    public Datastore batchDataStore(MongoClient mongoClient) {
        logger.info("Configuring Batch database: {}", (Object)this.batchDatabase);
        Datastore datastore = Morphia.createDatastore((MongoClient)mongoClient, (String)this.batchDatabase);
        datastore.getMapper().mapPackage(JobExecutionEntity.class.getPackageName());
        datastore.ensureIndexes();
        return datastore;
    }
}

