/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.mongo.repository;

import com.mongodb.client.result.UpdateResult;
import dev.morphia.Datastore;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.experimental.updates.UpdateOperators;
import eu.europeana.entitymanagement.definitions.model.EntityIdGenerator;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.web.EntityIdDisabledStatus;
import eu.europeana.entitymanagement.mongo.utils.MorphiaUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="emEntityRecordRepo")
public class EntityRecordRepository {
    @Resource(name="emDataStore")
    private Datastore datastore;

    public long count() {
        return this.datastore.find(EntityRecord.class).count();
    }

    public boolean existsByEntityId(String entityId) {
        return this.datastore.find(EntityRecord.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).count() > 0L;
    }

    public EntityRecord findByEntityId(String entityId) {
        return (EntityRecord)this.datastore.find(EntityRecord.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).first();
    }

    public List<EntityRecord> findByEntityIds(List<String> entityIds, boolean excludeDisabled, boolean fetchFullRecord) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filters.in((String)"entityId", entityIds));
        if (excludeDisabled) {
            filters.add(Filters.eq((String)"disabled", null));
        }
        FindOptions findOptions = new FindOptions();
        if (!fetchFullRecord) {
            findOptions.projection().include(new String[]{"entityId"}).projection().include(new String[]{"disabled"});
        }
        return this.datastore.find(EntityRecord.class).filter((Filter[])filters.toArray(Filter[]::new)).iterator(findOptions).toList();
    }

    public List<EntityIdDisabledStatus> getEntityIds(List<String> entityIds, boolean excludeDisabled) {
        List<EntityRecord> entityRecords = this.findByEntityIds(entityIds, excludeDisabled, false);
        return entityRecords.stream().map(entityRecord -> new EntityIdDisabledStatus(entityRecord.getEntityId(), entityRecord.isDisabled())).collect(Collectors.toList());
    }

    public long deleteForGood(String entityId) {
        return this.datastore.find(EntityRecord.class).filter(new Filter[]{Filters.eq((String)"entityId", (Object)entityId)}).delete().getDeletedCount();
    }

    public EntityRecord save(EntityRecord entityRecord) {
        return (EntityRecord)this.datastore.save((Object)entityRecord);
    }

    public long generateAutoIncrement(String internalType) {
        EntityIdGenerator autoIncrement = (EntityIdGenerator)this.datastore.find(EntityIdGenerator.class).filter(new Filter[]{Filters.eq((String)"_id", (Object)internalType)}).modify(UpdateOperators.inc((String)"value"), new UpdateOperator[0]).execute(MorphiaUtils.MAJORITY_WRITE_MODIFY_OPTS);
        if (autoIncrement == null) {
            autoIncrement = new EntityIdGenerator(internalType, 1L);
            this.datastore.save((Object)autoIncrement);
        }
        return autoIncrement.getValue();
    }

    public void dropCollection() {
        this.datastore.getMapper().getCollection(EntityRecord.class).drop();
        this.datastore.getMapper().getCollection(EntityIdGenerator.class).drop();
    }

    public Optional<EntityRecord> findEntityDupplicationByCoreference(List<String> uris, String entityId) {
        Query query = this.datastore.find(EntityRecord.class).disableValidation().filter(new Filter[]{Filters.or((Filter[])new Filter[]{Filters.in((String)"entity.sameAs", uris), Filters.in((String)"entity.exactMatch", uris)})});
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            query.filter(new Filter[]{Filters.ne((String)"entityId", (Object)entityId)});
        }
        EntityRecord value = (EntityRecord)query.first();
        return Optional.ofNullable(value);
    }

    public List<EntityRecord> saveBulk(List<EntityRecord> entityRecords) {
        return this.datastore.save(entityRecords);
    }

    public List<EntityRecord> findWithFilters(int start, int count, Filter[] filters) {
        return this.datastore.find(EntityRecord.class).filter(filters).iterator(new FindOptions().skip(start).sort(new Sort[]{Sort.ascending((String)"modified")}).limit(count)).toList();
    }

    public long deleteBulk(List<String> entityIds) {
        return this.datastore.find(EntityRecord.class).filter(new Filter[]{Filters.in((String)"entityId", entityIds)}).delete(MorphiaUtils.MULTI_DELETE_OPTS).getDeletedCount();
    }

    public UpdateResult disableBulk(List<String> entityIds) {
        Date disablingDate = new Date();
        return this.datastore.find(EntityRecord.class).filter(new Filter[]{Filters.in((String)"entityId", entityIds)}).update(UpdateOperators.set((String)"disabled", (Object)disablingDate), new UpdateOperator[0]).execute(MorphiaUtils.MULTI_UPDATE_OPTS);
    }
}

