/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.service;

import com.mongodb.MongoException;
import eu.europeana.enrichment.internal.model.AbstractEnrichmentEntity;
import eu.europeana.enrichment.internal.model.EnrichmentTerm;
import eu.europeana.enrichment.service.dao.EnrichmentDao;
import eu.europeana.enrichment.utils.EntityType;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.model.EnrichmentEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnrichmentService {
    private static final Logger LOG = LogManager.getLogger(EnrichmentService.class);
    private EnrichmentDao enrichmentDao;

    @Lazy
    @Autowired
    public EnrichmentService(EnrichmentDao enrichmentDao) {
        this.enrichmentDao = enrichmentDao;
    }

    public void saveEnrichment(EntityRecord entityRecord) {
        try {
            EnrichmentTerm enrichmentTerm = new EnrichmentTerm();
            EnrichmentEntity enrichmentEntity = new EnrichmentEntity();
            enrichmentEntity.setAbout(entityRecord.getEntityId());
            enrichmentEntity.setPrefLabel(Entity.toStringListMap((Map)entityRecord.getEntity().getPrefLabel()));
            enrichmentEntity.setAltLabel(entityRecord.getEntity().getAltLabel());
            if (entityRecord.getEntity().getHiddenLabel() != null) {
                HashMap hiddenLabelEnrichment = new HashMap();
                hiddenLabelEnrichment.put("def", new ArrayList(entityRecord.getEntity().getHiddenLabel()));
                enrichmentEntity.setHiddenLabel(hiddenLabelEnrichment);
            }
            enrichmentEntity.setNote(entityRecord.getEntity().getNote());
            if (!CollectionUtils.isEmpty((Collection)entityRecord.getEntity().getSameReferenceLinks())) {
                enrichmentEntity.setOwlSameAs(entityRecord.getEntity().getSameReferenceLinks());
            }
            enrichmentEntity.setIsPartOf(String.valueOf(entityRecord.getEntity().getIsPartOfArray()));
            enrichmentEntity.setFoafDepiction(entityRecord.getEntity().getDepiction() != null ? entityRecord.getEntity().getDepiction().getId() : null);
            enrichmentTerm.setEntityType(EntityType.valueOf((String)entityRecord.getEntity().getType().toUpperCase()));
            enrichmentTerm.setEnrichmentEntity((AbstractEnrichmentEntity)enrichmentEntity);
            Optional existingEnrichment = this.enrichmentDao.getEnrichmentTermByField("enrichmentEntity.about", (Object)entityRecord.getEntityId());
            if (existingEnrichment.isEmpty()) {
                enrichmentTerm.setCreated(new Date());
                enrichmentTerm.setUpdated(new Date());
            } else {
                LOG.debug("Enrichment already exist for entity {}. Updating the Enrichment", (Object)entityRecord.getEntityId());
                enrichmentTerm.setCreated(((EnrichmentTerm)existingEnrichment.get()).getCreated());
                enrichmentTerm.setUpdated(new Date());
                enrichmentTerm.setId(((EnrichmentTerm)existingEnrichment.get()).getId());
            }
            this.enrichmentDao.saveEnrichmentTerm(enrichmentTerm);
        }
        catch (MongoException e) {
            LOG.error("Error publishing entity {} - {}", (Object)entityRecord.getEntity().getAbout(), (Object)e.getMessage());
        }
    }
}

