/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.utils;

import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class EntityRecordUtils {
    public static final String ENTITY_ID_REMOVED_MSG = "Entity '%s' has been removed";
    public static final String MULTIPLE_CHOICES_FOR_REDIRECTION_MSG = "There are multiple choices for redirecting the entity id: '%s'. They include: '%s'.";

    private EntityRecordUtils() {
    }

    public static String buildEntityIdUri(EntityTypes type, String identifier) {
        return EntityRecordUtils.buildEntityIdUri(type.getUrlPath(), identifier);
    }

    private static String buildEntityIdUri(@NotNull String type, @NotNull String identifier) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://data.europeana.eu/").append(type.toLowerCase(Locale.ENGLISH)).append('/').append(identifier);
        return stringBuilder.toString();
    }

    public static String extractEntityPathFromEntityId(String entityId) {
        return entityId.replace("http://data.europeana.eu/", "");
    }

    public static String getEuropeanaAggregationId(String entityId) {
        return entityId + "#aggr_europeana";
    }

    public static String getDatasourceAggregationId(String entityId, int aggregationId) {
        return entityId + "#aggr_source_" + aggregationId;
    }

    public static String getIsAggregatedById(String entityId) {
        return entityId + "#aggregation";
    }

    public static String getEuropeanaProxyId(String entityId) {
        return entityId + "#proxy_europeana";
    }

    public static String getIdentifierFromUrl(String url) {
        if (!url.contains("/")) {
            return url;
        }
        return StringUtils.substringAfterLast((String)url, (String)"/");
    }

    public static String getEntityRequestPath(String entityId) {
        String[] parts = entityId.split("/");
        return parts[parts.length - 2] + "/" + parts[parts.length - 1];
    }

    public static String getEntityRequestPathWithBase(String entityId) {
        String[] parts = entityId.split("/");
        return parts[parts.length - 2] + "/base/" + parts[parts.length - 1];
    }

    public static List<String> getEntityIds(List<EntityRecord> entities) {
        if (entities == null || entities.isEmpty()) {
            return Collections.emptyList();
        }
        return entities.stream().map(e -> e.getEntityId()).toList();
    }

    public static boolean isEuropeanaEntity(String id) {
        return id != null && id.startsWith("http://data.europeana.eu/");
    }

    public static String buildRedirectionLocation(String identifier, String redirectionEntityId, String requestUri, String queryString) {
        String redirectionIdentifier = EntityRecordUtils.getIdentifierFromUrl(redirectionEntityId);
        Object redirectLocation = requestUri.replaceFirst(identifier, redirectionIdentifier);
        if (queryString != null) {
            redirectLocation = (String)redirectLocation + "?" + queryString;
        }
        return redirectLocation;
    }
}

