/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(namespace="http://www.w3.org/2006/vcard/ns#", name="Address")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XmlAddressImpl {
    @XmlAttribute(namespace="http://www.w3.org/1999/02/22-rdf-syntax-ns#", name="about")
    private String about;
    @XmlElement(namespace="http://www.w3.org/2006/vcard/ns#", name="street-address")
    private String streetAddress;
    @XmlElement(namespace="http://www.w3.org/2006/vcard/ns#", name="postal-code")
    private String postalCode;
    @XmlElement(namespace="http://www.w3.org/2006/vcard/ns#", name="post-office-box")
    private String postBox;
    @XmlElement(namespace="http://www.w3.org/2006/vcard/ns#", name="locality")
    private String locality;
    @XmlElement(namespace="http://www.w3.org/2006/vcard/ns#", name="country-name")
    private String countryName;
    @XmlElement(namespace="http://www.w3.org/2006/vcard/ns#", name="hasGeo")
    private LabelledResource hasGeo;

    public XmlAddressImpl() {
    }

    public XmlAddressImpl(Address address) {
        if (StringUtils.isNotEmpty((CharSequence)address.getAbout())) {
            this.about = address.getAbout();
        }
        this.streetAddress = address.getVcardStreetAddress();
        this.locality = address.getVcardLocality();
        this.countryName = address.getVcardCountryName();
        this.postalCode = address.getVcardPostalCode();
        this.postBox = address.getVcardPostOfficeBox();
        this.locality = address.getVcardLocality();
        if (StringUtils.isNotEmpty((CharSequence)address.getVcardHasGeo())) {
            this.hasGeo = new LabelledResource(EntityUtils.toGeoUri(address.getVcardHasGeo()));
        }
    }

    public String getAbout() {
        return this.about;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getPostBox() {
        return this.postBox;
    }

    public String getLocality() {
        return this.locality;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public LabelledResource getHasGeo() {
        return this.hasGeo;
    }

    public Address toAddress() {
        Address address = new Address();
        address.setAbout(this.about);
        address.setVcardStreetAddress(this.streetAddress);
        address.setVcardPostalCode(this.postalCode);
        address.setVcardPostOfficeBox(this.postBox);
        address.setVcardLocality(this.locality);
        address.setVcardCountryName(this.countryName);
        if (this.hasGeo != null) {
            address.setVcardHasGeo(this.hasGeo.getResource());
        }
        return address;
    }

    public boolean hasMetadataProperties() {
        return StringUtils.isNotEmpty((CharSequence)this.streetAddress) || StringUtils.isNotEmpty((CharSequence)this.postalCode) || StringUtils.isNotEmpty((CharSequence)this.postBox) || StringUtils.isNotEmpty((CharSequence)this.locality) || StringUtils.isNotEmpty((CharSequence)this.countryName) || this.hasGeo != null;
    }
}

