/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.vocabulary;

import eu.europeana.entitymanagement.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entitymanagement.vocabulary.EntityKeyword;

public enum EntityTypes implements EntityKeyword
{
    Organization("Organization", "organization", "http://www.europeana.eu/schemas/edm/Organization"),
    Concept("Concept", "concept", "https://www.w3.org/2009/08/skos-reference/skos.html#Concept"),
    ConceptScheme("ConceptScheme", "scheme", "https://www.w3.org/2009/08/skos-reference/skos.html#ConceptScheme"),
    Agent("Agent", "agent", "http://www.europeana.eu/schemas/edm/Agent"),
    Place("Place", "place", "http://www.europeana.eu/schemas/edm/Place"),
    TimeSpan("TimeSpan", "timespan", "http://www.europeana.eu/schemas/edm/TimeSpan");

    private String entityType;
    private String urlPath;
    private String httpUri;

    public String getEntityType() {
        return this.entityType;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    private EntityTypes(String entityType, String stringForUrl, String uri) {
        this.entityType = entityType;
        this.urlPath = stringForUrl;
        this.httpUri = uri;
    }

    @Deprecated
    public static boolean contains(String entityType) {
        for (EntityTypes field : EntityTypes.values()) {
            if (!field.getEntityType().equalsIgnoreCase(entityType)) continue;
            return true;
        }
        return false;
    }

    public static boolean arrayHasValue(EntityTypes[] entityTypes, EntityTypes entityType) {
        for (EntityTypes entType : entityTypes) {
            if (!entType.equals(entityType)) continue;
            return true;
        }
        return false;
    }

    public static EntityTypes getByEntityType(String entityType) throws UnsupportedEntityTypeException {
        for (EntityTypes entityTypeEnum : EntityTypes.values()) {
            if (!entityTypeEnum.getEntityType().equalsIgnoreCase(entityType)) continue;
            return entityTypeEnum;
        }
        throw new UnsupportedEntityTypeException(entityType);
    }

    public static EntityTypes getByEntityId(String entityId) throws UnsupportedEntityTypeException {
        for (EntityTypes entityType : EntityTypes.values()) {
            if (!entityId.contains(String.format("/%s/", entityType.getUrlPath()))) continue;
            return entityType;
        }
        throw new UnsupportedEntityTypeException(entityId);
    }

    public String getHttpUri() {
        return this.httpUri;
    }

    @Override
    public String getJsonValue() {
        return this.getEntityType();
    }

    public static boolean isTimeSpan(String entityType) {
        return TimeSpan.getEntityType().equals(entityType);
    }

    public static boolean isOrganization(String entityType) {
        return Organization.getEntityType().equals(entityType);
    }
}

