/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.utils;

import eu.europeana.corelib.edm.model.schemaorg.BaseType;
import eu.europeana.corelib.edm.model.schemaorg.ContextualEntity;
import eu.europeana.corelib.edm.model.schemaorg.EdmOrganization;
import eu.europeana.corelib.edm.model.schemaorg.GeoCoordinates;
import eu.europeana.corelib.edm.model.schemaorg.MultilingualString;
import eu.europeana.corelib.edm.model.schemaorg.Organization;
import eu.europeana.corelib.edm.model.schemaorg.Person;
import eu.europeana.corelib.edm.model.schemaorg.PostalAddress;
import eu.europeana.corelib.edm.model.schemaorg.Reference;
import eu.europeana.corelib.edm.model.schemaorg.Text;
import eu.europeana.corelib.edm.model.schemaorg.Thing;
import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import eu.europeana.entitymanagement.utils.UriValidator;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SchemaOrgUtils {
    private static final Logger LOG = LogManager.getLogger(SchemaOrgUtils.class);
    private static final String URL_PREFIX = "http://data.europeana.eu";

    private SchemaOrgUtils() {
    }

    public static void processEntity(Entity entity, ContextualEntity contextualEntity) {
        if (entity instanceof Concept) {
            SchemaOrgUtils.processConcept((Concept)entity, contextualEntity);
        } else if (entity instanceof Place) {
            SchemaOrgUtils.processPlace((Place)entity, contextualEntity);
        } else if (entity instanceof eu.europeana.entitymanagement.definitions.model.Organization) {
            SchemaOrgUtils.processOrganization((eu.europeana.entitymanagement.definitions.model.Organization)entity, contextualEntity);
        } else if (entity instanceof Agent) {
            SchemaOrgUtils.processAgent((Agent)entity, contextualEntity);
        } else if (entity instanceof TimeSpan) {
            SchemaOrgUtils.processTimespan((TimeSpan)entity, contextualEntity);
        }
    }

    public static void processConcept(Concept concept, ContextualEntity conceptObject) {
        conceptObject.setId(concept.getAbout());
        SchemaOrgUtils.addMultilingualProperties((Thing)conceptObject, "name", concept.getPrefLabel());
        SchemaOrgUtils.addMultilingualProperties((Thing)conceptObject, concept.getAltLabel(), "alternateName");
        SchemaOrgUtils.addMultilingualProperties((Thing)conceptObject, concept.getNote(), "description");
        SchemaOrgUtils.addTextProperties((Thing)conceptObject, concept.getSameReferenceLinks(), "sameAs");
        SchemaOrgUtils.addEntityPageUrl(concept, conceptObject, "topic");
        if (concept.getDepiction() != null) {
            conceptObject.setImage(concept.getDepiction().getThumbnail());
        } else if (concept.getIsShownBy() != null) {
            conceptObject.setImage(concept.getIsShownBy().getThumbnail());
        }
    }

    private static void addEntityPageUrl(Entity entity, ContextualEntity conceptObject, String entityPageType) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)entity.getAbout(), (CharSequence)URL_PREFIX)) {
            String entityPageUrl = String.format("https://www.europeana.eu/en/collections/%s/%s", entityPageType, EntityRecordUtils.getIdentifierFromUrl(entity.getEntityId()));
            conceptObject.setEntityPageUrl(entityPageUrl);
        }
    }

    public static void processPlace(Place edmPlace, ContextualEntity placeObject) {
        if (edmPlace == null) {
            return;
        }
        placeObject.setId(edmPlace.getAbout());
        SchemaOrgUtils.addMultilingualProperties((Thing)placeObject, "name", edmPlace.getPrefLabel());
        SchemaOrgUtils.addMultilingualProperties((Thing)placeObject, edmPlace.getAltLabel(), "alternateName");
        SchemaOrgUtils.createGeoCoordinates(edmPlace, (eu.europeana.corelib.edm.model.schemaorg.Place)placeObject);
        SchemaOrgUtils.addMultilingualProperties((Thing)placeObject, edmPlace.getNote(), "description");
        SchemaOrgUtils.addReferences((Thing)placeObject, edmPlace.getHasPart(), "containsPlace", eu.europeana.corelib.edm.model.schemaorg.Place.class, null);
        SchemaOrgUtils.addReferences((Thing)placeObject, edmPlace.getIsPartOfArray(), "containedInPlace", eu.europeana.corelib.edm.model.schemaorg.Place.class, null);
        SchemaOrgUtils.addTextProperties((Thing)placeObject, edmPlace.getSameReferenceLinks(), "sameAs");
        if (edmPlace.getDepiction() != null) {
            placeObject.setImage(edmPlace.getDepiction().getThumbnail());
        } else if (edmPlace.getIsShownBy() != null) {
            placeObject.setImage(edmPlace.getIsShownBy().getThumbnail());
        }
    }

    private static void createGeoCoordinates(Place edmPlace, eu.europeana.corelib.edm.model.schemaorg.Place placeObject) {
        GeoCoordinates geoCoordinates = new GeoCoordinates();
        if (edmPlace.getLatitude() != null) {
            geoCoordinates.addLatitude(new Text(String.valueOf(edmPlace.getLatitude())));
        }
        if (edmPlace.getLongitude() != null) {
            geoCoordinates.addLongitude(new Text(String.valueOf(edmPlace.getLongitude())));
        }
        if (edmPlace.getAltitude() != null) {
            geoCoordinates.addElevation(new Text(String.valueOf(edmPlace.getAltitude())));
        }
        placeObject.addGeo(geoCoordinates);
    }

    public static void processAgent(Agent agent, ContextualEntity agentObject) {
        agentObject.setId(agent.getAbout());
        SchemaOrgUtils.addMultilingualProperties((Thing)agentObject, "name", agent.getPrefLabel());
        SchemaOrgUtils.addMultilingualProperties((Thing)agentObject, "name", agent.getName());
        SchemaOrgUtils.addMultilingualProperties((Thing)agentObject, agent.getAltLabel(), "alternateName");
        SchemaOrgUtils.addMultilingualProperties((Thing)agentObject, agent.getNote(), "description");
        SchemaOrgUtils.addMultilingualProperties((Thing)agentObject, agent.getBiographicalInformation(), "description");
        if (agentObject instanceof Person) {
            if (agent.getDateOfBirth() != null) {
                SchemaOrgUtils.addStringProperties((Thing)agentObject, agent.getDateOfBirth(), "birthDate");
            } else if (agent.getBegin() != null) {
                SchemaOrgUtils.addStringProperties((Thing)agentObject, agent.getBegin(), "birthDate");
            }
            if (agent.getDateOfDeath() != null) {
                SchemaOrgUtils.addStringProperties((Thing)agentObject, agent.getDateOfDeath(), "deathDate");
            } else if (agent.getEnd() != null) {
                SchemaOrgUtils.addStringProperties((Thing)agentObject, agent.getEnd(), "deathDate");
            }
            if (agent.getGender() != null) {
                SchemaOrgUtils.addStringProperty((Thing)agentObject, String.valueOf(CollectionUtils.get(agent.getGender(), (int)0)), "gender");
            }
            SchemaOrgUtils.addStringProperties((Thing)agentObject, agent.getProfessionOrOccupation(), "jobTitle");
            SchemaOrgUtils.addResourceOrReferenceProperties((Thing)agentObject, agent.getPlaceOfBirth(), "birthPlace", eu.europeana.corelib.edm.model.schemaorg.Place.class, null);
            SchemaOrgUtils.addResourceOrReferenceProperties((Thing)agentObject, agent.getPlaceOfDeath(), "deathPlace", eu.europeana.corelib.edm.model.schemaorg.Place.class, null);
        }
        if (agentObject instanceof Organization) {
            if (agent.getDateOfEstablishment() != null) {
                SchemaOrgUtils.addStringProperty((Thing)agentObject, String.valueOf(CollectionUtils.get(agent.getDateOfEstablishment(), (int)0)), "foundingDate");
            }
            if (agent.getDateOfTermination() != null) {
                SchemaOrgUtils.addStringProperty((Thing)agentObject, String.valueOf(CollectionUtils.get(agent.getDateOfTermination(), (int)0)), "dissolutionDate");
            }
        }
        SchemaOrgUtils.addTextProperties((Thing)agentObject, agent.getSameReferenceLinks(), "sameAs");
        SchemaOrgUtils.addEntityPageUrl(agent, agentObject, "person");
        if (agent.getDepiction() != null) {
            agentObject.setImage(agent.getDepiction().getThumbnail());
        } else if (agent.getIsShownBy() != null) {
            agentObject.setImage(agent.getIsShownBy().getThumbnail());
        }
    }

    public static void processOrganization(eu.europeana.entitymanagement.definitions.model.Organization organization, ContextualEntity entityObject) {
        entityObject.setId(organization.getAbout());
        SchemaOrgUtils.addMultilingualProperties((Thing)entityObject, "name", organization.getPrefLabel());
        SchemaOrgUtils.addMultilingualProperties((Thing)entityObject, organization.getAltLabel(), "alternateName");
        SchemaOrgUtils.addMultilingualProperties((Thing)entityObject, organization.getAcronym(), "alternateName");
        SchemaOrgUtils.addMultilingualProperties((Thing)entityObject, "description", organization.getDescription());
        SchemaOrgUtils.addTextProperties((Thing)entityObject, Arrays.asList(organization.getHomepage()), "mainEntityOfPage");
        if (organization.getLogo() != null) {
            SchemaOrgUtils.addTextProperties((Thing)entityObject, Arrays.asList(organization.getLogo().getId()), "logo");
        }
        SchemaOrgUtils.addTextProperties((Thing)entityObject, organization.getPhone(), "telephone");
        SchemaOrgUtils.createPostalAddress(organization, (EdmOrganization)entityObject);
        SchemaOrgUtils.addTextProperties((Thing)entityObject, organization.getIdentifier(), "identifier");
        SchemaOrgUtils.addTextProperties((Thing)entityObject, organization.getSameReferenceLinks(), "sameAs");
        SchemaOrgUtils.addEntityPageUrl(organization, entityObject, "organization");
        if (organization.getDepiction() != null) {
            entityObject.setImage(organization.getDepiction().getThumbnail());
        } else if (organization.getIsShownBy() != null) {
            entityObject.setImage(organization.getIsShownBy().getThumbnail());
        }
    }

    public static void processTimespan(TimeSpan time, ContextualEntity timespanObject) {
        timespanObject.setId(time.getAbout());
        SchemaOrgUtils.addMultilingualProperties((Thing)timespanObject, "name", time.getPrefLabel());
        SchemaOrgUtils.addMultilingualProperties((Thing)timespanObject, time.getAltLabel(), "alternateName");
        SchemaOrgUtils.addMultilingualProperties((Thing)timespanObject, time.getNote(), "description");
        SchemaOrgUtils.addEntityPageUrl(time, timespanObject, "time");
        SchemaOrgUtils.addTextProperties((Thing)timespanObject, time.getSameReferenceLinks(), "sameAs");
        if (time.getDepiction() != null) {
            timespanObject.setImage(time.getDepiction().getThumbnail());
        } else if (time.getIsShownBy() != null) {
            timespanObject.setImage(time.getIsShownBy().getThumbnail());
        }
    }

    private static void createPostalAddress(eu.europeana.entitymanagement.definitions.model.Organization organization, EdmOrganization organizationObject) {
        PostalAddress postalAddress = new PostalAddress();
        Address address = organization.getAddress();
        if (address == null) {
            return;
        }
        postalAddress.setId(address.getAbout());
        SchemaOrgUtils.addTextProperties((Thing)postalAddress, Arrays.asList(address.getVcardStreetAddress()), "streetAddress");
        SchemaOrgUtils.addTextProperties((Thing)postalAddress, Arrays.asList(address.getVcardPostalCode()), "postalCode");
        SchemaOrgUtils.addTextProperties((Thing)postalAddress, Arrays.asList(address.getVcardPostOfficeBox()), "postOfficeBoxNumber");
        SchemaOrgUtils.addTextProperties((Thing)postalAddress, Arrays.asList(address.getVcardLocality()), "addressLocality");
        SchemaOrgUtils.addTextProperties((Thing)postalAddress, Arrays.asList(address.getVcardCountryName()), "addressCountry");
        organizationObject.addAddress(postalAddress);
    }

    private static void addMultilingualProperties(Thing object, Map<String, List<String>> map, String propertyName) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            SchemaOrgUtils.addMultilingualProperties(object, entry.getValue(), "def".equals(entry.getKey()) ? "" : entry.getKey(), propertyName);
        }
    }

    private static void addMultilingualProperties(Thing object, String propertyName, Map<String, String> map) {
        if (map == null) {
            return;
        }
        String language = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            language = "def".equals(entry.getKey()) ? "" : entry.getKey();
            SchemaOrgUtils.addMultilingualProperty(object, entry.getValue(), language, propertyName);
        }
    }

    private static void addMultilingualProperties(Thing object, List<String> values, String language, String propertyName) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            if (!SchemaOrgUtils.notNullNorEmpty(value)) continue;
            SchemaOrgUtils.addMultilingualProperty(object, value, language, propertyName);
        }
    }

    private static void addMultilingualProperty(Thing object, String value, String language, String propertyName) {
        MultilingualString property = new MultilingualString();
        property.setLanguage(language);
        property.setValue(value);
        object.addProperty(propertyName, (BaseType)property);
    }

    private static void addStringProperties(Thing object, List<String> values, String propertyName) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            if (!SchemaOrgUtils.notNullNorEmpty(value)) continue;
            SchemaOrgUtils.addStringProperty(object, value, propertyName);
        }
    }

    private static void addStringProperty(Thing object, String value, String propertyName) {
        object.addProperty(propertyName, (BaseType)new Text(value));
    }

    private static void addResourceOrReferenceProperties(Thing object, List<String> entry, String propertyName, Class<? extends Thing> referenceClass, List<String> linkedContextualEntities) {
        if (entry == null) {
            return;
        }
        for (String value : entry) {
            if (UriValidator.isUri(value)) {
                referenceClass = SchemaOrgUtils.referenceNull(propertyName, value) ? null : SchemaOrgUtils.getReferenceClass(value);
                SchemaOrgUtils.addProperty(object, value, "", propertyName, referenceClass, linkedContextualEntities);
                continue;
            }
            SchemaOrgUtils.addResourceProperty(object, value, "", propertyName, referenceClass);
        }
    }

    private static void addReferences(Thing object, List<String> values, String propertyName, Class<? extends Thing> referenceClass, List<String> linkedContextualEntities) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            SchemaOrgUtils.addLinkedContextualEntities(value, linkedContextualEntities);
            SchemaOrgUtils.addReference(object, value, propertyName, referenceClass);
        }
    }

    private static void addProperty(Thing object, String value, String language, String propertyName, Class<? extends Thing> referenceClass, List<String> linkedContextualEntities) {
        if (SchemaOrgUtils.notNullNorEmpty(value)) {
            if (UriValidator.isUri(value)) {
                SchemaOrgUtils.addLinkedContextualEntities(value, linkedContextualEntities);
                SchemaOrgUtils.addReference(object, value, propertyName, referenceClass);
            } else {
                SchemaOrgUtils.addMultilingualProperty(object, value, "def".equals(language) ? "" : language, propertyName);
            }
        }
    }

    private static void addReference(Thing object, String id, String propertyName, Class<? extends Thing> referenceClass) {
        Reference reference = new Reference(referenceClass);
        reference.setId(id);
        object.addProperty(propertyName, (BaseType)reference);
    }

    private static void addResourceProperty(Thing object, String value, String language, String propertyName, Class<? extends Thing> referenceClass) {
        if (SchemaOrgUtils.notNullNorEmpty(value)) {
            Thing resource = SchemaOrgUtils.instantiateResourceObject(referenceClass);
            if (StringUtils.equals((CharSequence)language, (CharSequence)"def")) {
                resource.addProperty("name", (BaseType)new Text(value));
            } else {
                SchemaOrgUtils.addMultilingualProperty(resource, value, language, "name");
            }
            object.addProperty(propertyName, (BaseType)resource);
        }
    }

    private static void addTextProperties(Thing object, List<String> values, String propertyName) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            if (!SchemaOrgUtils.notNullNorEmpty(value)) continue;
            object.addProperty(propertyName, (BaseType)new Text(value));
        }
    }

    private static Thing instantiateResourceObject(Class<? extends Thing> referenceClass) {
        Thing resource;
        block3: {
            if (referenceClass == null) {
                return new Thing();
            }
            resource = null;
            try {
                resource = referenceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                resource = new Thing();
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Cannot instantiate object of class {} . Instance of Thing is used instead!", (Object)referenceClass.getCanonicalName(), (Object)e);
            }
        }
        return resource;
    }

    private static boolean notNullNorEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    private static boolean referenceNull(String propertyName, String propertyValue) {
        if (!StringUtils.startsWith((CharSequence)propertyValue, (CharSequence)URL_PREFIX)) {
            return StringUtils.equals((CharSequence)propertyName, (CharSequence)"about") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"contributor") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"creator") || StringUtils.equals((CharSequence)propertyName, (CharSequence)"publisher");
        }
        return false;
    }

    private static Class<? extends Thing> getReferenceClass(String propertyValue) {
        if (StringUtils.startsWith((CharSequence)propertyValue, (CharSequence)URL_PREFIX)) {
            if (propertyValue.startsWith("http://data.europeana.eu/agent")) {
                return Person.class;
            }
            if (propertyValue.startsWith("http://data.europeana.eu/place")) {
                return eu.europeana.corelib.edm.model.schemaorg.Place.class;
            }
            if (propertyValue.contains("http://data.europeana.eu/concept")) {
                return Thing.class;
            }
            if (propertyValue.contains("http://data.europeana.eu/organization")) {
                return EdmOrganization.class;
            }
            return Thing.class;
        }
        return null;
    }

    private static void addLinkedContextualEntities(String value, List<String> linkedContextualEntities) {
        if (linkedContextualEntities != null) {
            linkedContextualEntities.add(value);
        }
    }
}

