/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EntityUtils {
    public static String createWikimediaResourceString(String wikimediaCommonsId) {
        if (wikimediaCommonsId != null && wikimediaCommonsId.contains("/Special:FilePath/")) {
            return wikimediaCommonsId.replace("/Special:FilePath/", "/File:");
        }
        return null;
    }

    public static String buildConceptSchemeId(String baseUrl, Long identifier) {
        StringBuilder builder = new StringBuilder();
        builder.append(baseUrl);
        if (baseUrl != null && !baseUrl.endsWith("/")) {
            builder.append('/');
        }
        return builder.append(identifier).toString();
    }

    public static String toGeoUri(String latLon) {
        if (latLon == null) {
            return null;
        }
        if (latLon.startsWith("geo:")) {
            return latLon;
        }
        return "geo:" + latLon;
    }

    public static String toGeoUri(String lat, String lon) {
        if (lat == null || lon == null) {
            return null;
        }
        return EntityUtils.toGeoUri(lat + "," + lon);
    }

    public static String toLatLongValue(String geoUri) {
        if (geoUri == null) {
            return null;
        }
        return geoUri.replaceFirst("geo:", "");
    }

    public static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> entityFields = new ArrayList<Field>();
        EntityUtils.getAllFieldsRecursively(entityFields, type);
        return entityFields;
    }

    private static void getAllFieldsRecursively(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            EntityUtils.getAllFieldsRecursively(fields, type.getSuperclass());
        }
    }
}

