/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Transient;
import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Aggregation;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.normalization.EntityFieldsCompleteValidationGroup;
import eu.europeana.entitymanagement.normalization.EntityFieldsCompleteValidationInterface;
import eu.europeana.entitymanagement.normalization.EntityFieldsDataSourceProxyValidationGroup;
import eu.europeana.entitymanagement.normalization.EntityFieldsDataSourceProxyValidationInterface;
import eu.europeana.entitymanagement.normalization.EntityFieldsEuropeanaProxyValidationGroup;
import eu.europeana.entitymanagement.normalization.EntityFieldsEuropeanaProxyValidationInterface;
import eu.europeana.entitymanagement.vocabulary.ValidationObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Embedded
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Agent.class, name="Agent"), @JsonSubTypes.Type(value=Concept.class, name="Concept"), @JsonSubTypes.Type(value=Organization.class, name="Organization"), @JsonSubTypes.Type(value=Place.class, name="Place"), @JsonSubTypes.Type(value=TimeSpan.class, name="TimeSpan")})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@EntityFieldsCompleteValidationInterface(groups={EntityFieldsCompleteValidationGroup.class})
@EntityFieldsEuropeanaProxyValidationInterface(groups={EntityFieldsEuropeanaProxyValidationGroup.class})
@EntityFieldsDataSourceProxyValidationInterface(groups={EntityFieldsDataSourceProxyValidationGroup.class})
public abstract class Entity
implements ValidationObject {
    @Transient
    protected String context = "http://www.europeana.eu/schemas/context/entity.jsonld";
    protected String entityId;
    protected Map<String, List<String>> note;
    protected Map<String, String> prefLabel;
    protected Map<String, List<String>> altLabel;
    protected List<String> hiddenLabel;
    protected List<String> identifier;
    protected List<String> isRelatedTo;
    protected List<String> inScheme;
    protected List<String> hasPart;
    protected List<String> isPartOf;
    protected Aggregation isAggregatedBy;
    protected WebResource isShownBy;
    protected WebResource depiction;
    protected String payload;

    protected Entity() {
    }

    protected <T extends Entity> Entity(T copy) {
        this.entityId = copy.getEntityId();
        this.depiction = copy.getDepiction();
        this.context = copy.getContext();
        if (copy.getNote() != null) {
            this.note = new HashMap<String, List<String>>(copy.getNote());
        }
        if (copy.getPrefLabel() != null) {
            this.prefLabel = new HashMap<String, String>(copy.getPrefLabel());
        }
        if (copy.getAltLabel() != null) {
            this.altLabel = new HashMap<String, List<String>>(copy.getAltLabel());
        }
        if (copy.getHiddenLabel() != null) {
            this.hiddenLabel = new ArrayList<String>(copy.getHiddenLabel());
        }
        if (copy.getIdentifier() != null) {
            this.identifier = new ArrayList<String>(copy.getIdentifier());
        }
        if (copy.getIsRelatedTo() != null) {
            this.isRelatedTo = new ArrayList<String>(copy.getIsRelatedTo());
        }
        if (copy.getHasPart() != null) {
            this.hasPart = new ArrayList<String>(copy.getHasPart());
        }
        if (copy.getIsPartOfArray() != null) {
            this.isPartOf = new ArrayList<String>(copy.getIsPartOfArray());
        }
        if (copy.getIsAggregatedBy() != null) {
            this.isAggregatedBy = new Aggregation(copy.getIsAggregatedBy());
        }
        if (copy.getIsShownBy() != null) {
            this.isShownBy = new WebResource(copy.getIsShownBy());
        }
        this.payload = copy.getPayload();
    }

    @JsonGetter(value="inScheme")
    public List<String> getInScheme() {
        return this.inScheme;
    }

    @JsonSetter(value="inScheme")
    public void setInScheme(List<String> inScheme) {
        this.inScheme = inScheme;
    }

    @JsonGetter(value="prefLabel")
    public Map<String, String> getPrefLabel() {
        return this.prefLabel;
    }

    @JsonSetter(value="prefLabel")
    public void setPrefLabel(Map<String, String> prefLabel) {
        this.prefLabel = prefLabel;
    }

    @JsonGetter(value="altLabel")
    public Map<String, List<String>> getAltLabel() {
        return this.altLabel;
    }

    @JsonSetter(value="altLabel")
    public void setAltLabel(Map<String, List<String>> altLabel) {
        this.altLabel = altLabel;
    }

    @JsonGetter(value="hiddenLabel")
    public List<String> getHiddenLabel() {
        return this.hiddenLabel;
    }

    @JsonSetter(value="hiddenLabel")
    public void setHiddenLabel(List<String> hiddenLabel) {
        this.hiddenLabel = hiddenLabel;
    }

    @JsonGetter(value="note")
    public Map<String, List<String>> getNote() {
        return this.note;
    }

    @JsonSetter(value="note")
    public void setNote(Map<String, List<String>> note) {
        this.note = note;
    }

    @JsonGetter(value="type")
    public abstract String getType();

    @JsonGetter(value="id")
    public String getEntityId() {
        return this.entityId;
    }

    @JsonSetter(value="id")
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @JsonGetter(value="identifier")
    public List<String> getIdentifier() {
        return this.identifier;
    }

    @JsonSetter(value="identifier")
    public void setIdentifier(List<String> identifier) {
        this.identifier = identifier;
    }

    @JsonIgnore
    public String getAbout() {
        return this.getEntityId();
    }

    public void setAbout(String about) {
        this.setEntityId(about);
    }

    @JsonGetter(value="isRelatedTo")
    public List<String> getIsRelatedTo() {
        return this.isRelatedTo;
    }

    @JsonSetter(value="isRelatedTo")
    public void setIsRelatedTo(List<String> isRelatedTo) {
        this.isRelatedTo = isRelatedTo;
    }

    @JsonGetter(value="hasPart")
    public List<String> getHasPart() {
        return this.hasPart;
    }

    @JsonSetter(value="hasPart")
    public void setHasPart(List<String> hasPart) {
        this.hasPart = hasPart;
    }

    @JsonGetter(value="isPartOf")
    public List<String> getIsPartOfArray() {
        return this.isPartOf;
    }

    @JsonSetter(value="isPartOf")
    public void setIsPartOfArray(List<String> isPartOf) {
        this.isPartOf = isPartOf;
    }

    @JsonGetter(value="depiction")
    public WebResource getDepiction() {
        return this.depiction;
    }

    @JsonSetter(value="depiction")
    public void setDepiction(WebResource depiction) {
        this.depiction = depiction;
    }

    @JsonGetter(value="isShownBy")
    public WebResource getIsShownBy() {
        return this.isShownBy;
    }

    @JsonSetter(value="isShownBy")
    public void setIsShownBy(WebResource resource) {
        this.isShownBy = resource;
    }

    @Override
    public Object getFieldValue(Field field) throws IllegalAccessException {
        if (!field.canAccess(this)) {
            field.setAccessible(true);
        }
        return field.get(this);
    }

    @Override
    public void setFieldValue(Field field, Object value) throws IllegalAccessException {
        if ("type".equals(field.getName())) {
            return;
        }
        field.set(this, value);
    }

    @JsonGetter(value="isAggregatedBy")
    public Aggregation getIsAggregatedBy() {
        return this.isAggregatedBy;
    }

    @JsonGetter(value="@context")
    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    @JsonSetter(value="isAggregatedBy")
    public void setIsAggregatedBy(Aggregation isAggregatedBy) {
        this.isAggregatedBy = isAggregatedBy;
    }

    @JsonIgnore
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public static Map<String, List<String>> toStringListMap(Map<String, String> stringMap) {
        return stringMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList((String)entry.getValue())));
    }

    public abstract List<String> getSameReferenceLinks();

    public abstract void setSameReferenceLinks(List<String> var1);

    public void addSameReferenceLink(String uri) {
        if (this.getSameReferenceLinks() == null) {
            this.setSameReferenceLinks(new ArrayList<String>());
        }
        if (!this.getSameReferenceLinks().contains(uri)) {
            this.getSameReferenceLinks().add(uri);
        }
    }
}

