/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"@context", "id", "type", "depiction", "isShownBy", "prefLabel", "altLabel", "hiddenLabel", "note", "notation", "broader", "narrower", "related", "broadMatch", "narrowMatch", "relatedMatch", "closeMatch", "exactMatch", "inScheme", "isAggregatedBy"})
public class Concept
extends Entity {
    private String type = EntityTypes.Concept.getEntityType();
    private List<String> broader;
    private List<String> narrower;
    private List<String> related;
    private List<String> broadMatch;
    private List<String> narrowMatch;
    private List<String> exactMatch;
    private List<String> coref;
    private List<String> relatedMatch;
    private List<String> closeMatch;
    private Map<String, List<String>> notation;

    public Concept() {
    }

    public Concept(Concept copy) {
        super(copy);
        if (copy.getBroader() != null) {
            this.broader = new ArrayList<String>(copy.getBroader());
        }
        if (copy.getNarrower() != null) {
            this.narrower = new ArrayList<String>(copy.getNarrower());
        }
        if (copy.getRelated() != null) {
            this.related = new ArrayList<String>(copy.getRelated());
        }
        if (copy.getBroadMatch() != null) {
            this.broadMatch = new ArrayList<String>(copy.getBroadMatch());
        }
        if (copy.getNarrowMatch() != null) {
            this.narrowMatch = new ArrayList<String>(copy.getNarrowMatch());
        }
        if (copy.getCoref() != null) {
            this.coref = new ArrayList<String>(copy.getCoref());
        }
        if (copy.getRelatedMatch() != null) {
            this.relatedMatch = new ArrayList<String>(copy.getRelatedMatch());
        }
        if (copy.getCloseMatch() != null) {
            this.closeMatch = new ArrayList<String>(copy.getCloseMatch());
        }
        if (copy.getInScheme() != null) {
            this.inScheme = new ArrayList<String>(copy.getInScheme());
        }
        if (copy.getNotation() != null) {
            this.notation = new HashMap<String, List<String>>(copy.getNotation());
        }
        if (copy.exactMatch != null) {
            this.exactMatch = new ArrayList<String>(copy.exactMatch);
        }
    }

    @JsonGetter(value="broader")
    public List<String> getBroader() {
        return this.broader;
    }

    @JsonSetter(value="broader")
    public void setBroader(List<String> broader) {
        this.broader = broader;
    }

    @JsonGetter(value="narrower")
    public List<String> getNarrower() {
        return this.narrower;
    }

    @JsonSetter(value="narrower")
    public void setNarrower(List<String> narrower) {
        this.narrower = narrower;
    }

    @JsonGetter(value="related")
    public List<String> getRelated() {
        return this.related;
    }

    @JsonSetter(value="related")
    public void setRelated(List<String> related) {
        this.related = related;
    }

    @JsonGetter(value="broadMatch")
    public List<String> getBroadMatch() {
        return this.broadMatch;
    }

    @JsonSetter(value="broadMatch")
    public void setBroadMatch(List<String> broadMatch) {
        this.broadMatch = broadMatch;
    }

    @JsonGetter(value="narrowMatch")
    public List<String> getNarrowMatch() {
        return this.narrowMatch;
    }

    @JsonSetter(value="narrowMatch")
    public void setNarrowMatch(List<String> narrowMatch) {
        this.narrowMatch = narrowMatch;
    }

    public List<String> getCoref() {
        return this.coref;
    }

    public void setCoref(List<String> coref) {
        this.coref = coref;
    }

    @JsonGetter(value="relatedMatch")
    public List<String> getRelatedMatch() {
        return this.relatedMatch;
    }

    @JsonSetter(value="relatedMatch")
    public void setRelatedMatch(List<String> relatedMatch) {
        this.relatedMatch = relatedMatch;
    }

    @JsonGetter(value="closeMatch")
    public List<String> getCloseMatch() {
        return this.closeMatch;
    }

    @JsonSetter(value="closeMatch")
    public void setCloseMatch(List<String> closeMatch) {
        this.closeMatch = closeMatch;
    }

    @JsonGetter(value="notation")
    public Map<String, List<String>> getNotation() {
        return this.notation;
    }

    @JsonSetter(value="notation")
    public void setNotation(Map<String, List<String>> notation) {
        this.notation = notation;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Object getFieldValue(Field field) throws IllegalAccessException {
        return field.get(this);
    }

    @Override
    public void setFieldValue(Field field, Object value) throws IllegalAccessException {
        field.set(this, value);
    }

    @Override
    @JsonSetter(value="exactMatch")
    public void setSameReferenceLinks(List<String> uris) {
        this.exactMatch = uris;
    }

    @Override
    @JsonGetter(value="exactMatch")
    public List<String> getSameReferenceLinks() {
        return this.exactMatch;
    }
}

