/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.batch.model;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import java.time.Instant;
import org.bson.types.ObjectId;

@Entity(value="ScheduledTasks")
@Indexes(value={@Index(fields={@Field(value="updateType"), @Field(value="hasBeenProcessed")}), @Index(fields={@Field(value="created"), @Field(value="entityId")})})
public class ScheduledTask {
    @Id
    private ObjectId dbId;
    private String entityId;
    private Instant created;
    private Instant modified;
    private ScheduledTaskType updateType;
    private boolean hasBeenProcessed;

    private ScheduledTask() {
    }

    public ScheduledTask(String entityId, ScheduledTaskType updateType, Instant modified, boolean hasBeenProcessed) {
        this.entityId = entityId;
        this.updateType = updateType;
        this.modified = modified;
        this.hasBeenProcessed = hasBeenProcessed;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Instant getCreated() {
        return this.created;
    }

    public Instant getModified() {
        return this.modified;
    }

    public ScheduledTaskType getUpdateType() {
        return this.updateType;
    }

    public boolean hasBeenProcessed() {
        return this.hasBeenProcessed;
    }

    public static class Builder {
        private final String entityId;
        private final ScheduledTaskType updateType;
        private Instant modified;
        private boolean hasBeenProcessed;

        public Builder(String entityId, ScheduledTaskType updateType) {
            this.entityId = entityId;
            this.updateType = updateType;
        }

        public Builder modified(Instant modified) {
            this.modified = modified;
            return this;
        }

        public Builder setProcessed(boolean hasBeenProcessed) {
            this.hasBeenProcessed = hasBeenProcessed;
            return this;
        }

        public ScheduledTask build() {
            return new ScheduledTask(this.entityId, this.updateType, this.modified, this.hasBeenProcessed);
        }
    }
}

