/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import dev.morphia.annotations.EntityListeners;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.Indexes;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityProxy;
import eu.europeana.entitymanagement.utils.EntityRecordWatcher;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@dev.morphia.annotations.Entity(value="EntityRecord")
@Indexes(value={@Index(fields={@Field(value="entity.type")}), @Index(fields={@Field(value="entity.exactMatch")}), @Index(fields={@Field(value="entity.sameAs")}), @Index(fields={@Field(value="modified")}), @Index(fields={@Field(value="entity.aggregatedVia")})})
@EntityListeners(value={EntityRecordWatcher.class})
public class EntityRecord {
    @Id
    @JsonIgnore
    private ObjectId dbId;
    @Indexed(options=@IndexOptions(unique=true))
    private String entityId;
    private Entity entity;
    private final List<EntityProxy> proxies = new ArrayList<EntityProxy>();
    @JsonIgnore
    private Date disabled;
    @JsonIgnore
    private Date created;
    @JsonIgnore
    private Date modified;

    @JsonGetter
    public Entity getEntity() {
        return this.entity;
    }

    @JsonSetter
    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @JsonGetter(value="id")
    public String getEntityId() {
        return this.entityId;
    }

    @JsonSetter(value="id")
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @JsonGetter
    public List<EntityProxy> getProxies() {
        return this.proxies;
    }

    @JsonSetter
    public void addProxy(EntityProxy proxy) {
        this.proxies.add(proxy);
    }

    public void setDbId(ObjectId dbId_param) {
        this.dbId = dbId_param;
    }

    public ObjectId getDbId() {
        return this.dbId;
    }

    public boolean isDisabled() {
        return this.disabled != null;
    }

    public Date getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Date disabledParam) {
        this.disabled = disabledParam;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getModified() {
        return this.modified;
    }

    public EntityProxy getEuropeanaProxy() {
        return this.proxies.stream().filter(s -> s.getProxyId().startsWith("http://data.europeana.eu/")).findFirst().orElse(null);
    }

    public EntityProxy getZohoProxy() {
        return this.getProxyByHost("crm.zoho.eu");
    }

    public EntityProxy getWikidataProxy() {
        return this.getProxyByHost("www.wikidata.org");
    }

    EntityProxy getProxyByHost(String host_name) {
        return this.proxies.stream().filter(s -> s.getProxyId().contains(host_name)).findFirst().orElse(null);
    }

    public List<EntityProxy> getExternalProxies() {
        return this.proxies.stream().filter(s -> !s.getProxyId().startsWith("http://data.europeana.eu/")).collect(Collectors.toList());
    }

    public List<String> getExternalProxyIds() {
        return this.proxies.stream().filter(s -> !s.getProxyId().startsWith("http://data.europeana.eu/")).map(EntityProxy::getProxyId).collect(Collectors.toList());
    }

    public String toString() {
        return String.format("EntityRecord.entityTd: %s", this.getEntityId());
    }
}

