/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.entitymanagement.definitions.exceptions.EntityModelCreationException;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import eu.europeana.entitymanagement.web.xml.model.RdfXmlUtils;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.w3.org/2004/02/skos/core#", name="Concept")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"about", "depiction", "isShownBy", "prefLabel", "altLabel", "hiddenLabel", "note", "notation", "broader", "narrower", "related", "broadMatch", "narrowMatch", "relatedMatch", "closeMatch", "exactMatch", "inScheme", "isAggregatedBy"})
public class XmlConceptImpl
extends XmlBaseEntityImpl<Concept> {
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="narrower")
    private List<LabelledResource> narrower = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="related")
    private List<LabelledResource> related = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="broader")
    private List<LabelledResource> broader = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="note")
    private List<LabelledResource> note = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="broadMatch")
    private List<LabelledResource> broadMatch = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="narrowMatch")
    private List<LabelledResource> narrowMatch = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="exactMatch")
    private List<LabelledResource> exactMatch = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="relatedMatch")
    private List<LabelledResource> relatedMatch = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="closeMatch")
    private List<LabelledResource> closeMatch = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="notation")
    private List<LabelledResource> notation;
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="inScheme")
    private List<LabelledResource> inScheme;

    public XmlConceptImpl() {
        this.entity = new Concept();
    }

    public XmlConceptImpl(Concept concept) {
        super(concept);
        this.exactMatch = RdfXmlUtils.convertToRdfResource(concept.getSameReferenceLinks());
        this.related = RdfXmlUtils.convertToRdfResource(concept.getRelated());
        this.narrower = RdfXmlUtils.convertToRdfResource(concept.getNarrower());
        this.broader = RdfXmlUtils.convertToRdfResource(concept.getBroader());
        this.broadMatch = RdfXmlUtils.convertToRdfResource(concept.getBroadMatch());
        this.narrowMatch = RdfXmlUtils.convertToRdfResource(concept.getNarrowMatch());
        this.relatedMatch = RdfXmlUtils.convertToRdfResource(concept.getRelatedMatch());
        this.closeMatch = RdfXmlUtils.convertToRdfResource(concept.getCloseMatch());
        this.note = RdfXmlUtils.convertToXmlMultilingualString(concept.getNote());
        this.notation = RdfXmlUtils.convertToXmlMultilingualString(concept.getNotation());
        this.inScheme = RdfXmlUtils.convertToRdfResource(concept.getInScheme());
    }

    @Override
    public Concept toEntityModel() throws EntityModelCreationException {
        super.toEntityModel();
        ((Concept)this.entity).setRelated(RdfXmlUtils.toStringList(this.getRelated()));
        ((Concept)this.entity).setNarrower(RdfXmlUtils.toStringList(this.getNarrower()));
        ((Concept)this.entity).setBroader(RdfXmlUtils.toStringList(this.getBroader()));
        ((Concept)this.entity).setBroadMatch(RdfXmlUtils.toStringList(this.getBroadMatch()));
        ((Concept)this.entity).setNarrowMatch(RdfXmlUtils.toStringList(this.getNarrowMatch()));
        ((Concept)this.entity).setRelatedMatch(RdfXmlUtils.toStringList(this.getRelatedMatch()));
        ((Concept)this.entity).setCloseMatch(RdfXmlUtils.toStringList(this.getCloseMatch()));
        ((Concept)this.entity).setInScheme(RdfXmlUtils.toStringList(this.getInScheme()));
        ((Concept)this.entity).setNote(RdfXmlUtils.toLanguageMapList(this.getNote()));
        ((Concept)this.entity).setNotation(RdfXmlUtils.toLanguageMapList(this.getNotation()));
        this.inScheme = RdfXmlUtils.convertToRdfResource(((Concept)this.entity).getInScheme());
        return (Concept)this.entity;
    }

    public List<LabelledResource> getBroader() {
        return this.broader;
    }

    public List<LabelledResource> getNarrower() {
        return this.narrower;
    }

    public List<LabelledResource> getRelated() {
        return this.related;
    }

    public List<LabelledResource> getBroadMatch() {
        return this.broadMatch;
    }

    public List<LabelledResource> getNarrowMatch() {
        return this.narrowMatch;
    }

    public List<LabelledResource> getExactMatch() {
        return this.exactMatch;
    }

    public List<LabelledResource> getRelatedMatch() {
        return this.relatedMatch;
    }

    public List<LabelledResource> getCloseMatch() {
        return this.closeMatch;
    }

    public List<LabelledResource> getNotation() {
        return this.notation;
    }

    public List<LabelledResource> getNote() {
        return this.note;
    }

    public List<LabelledResource> getInScheme() {
        return this.inScheme;
    }

    public void setInScheme(List<LabelledResource> inScheme) {
        this.inScheme = inScheme;
    }

    @Override
    protected EntityTypes getTypeEnum() {
        return EntityTypes.Concept;
    }

    @Override
    public List<LabelledResource> getSameReferenceLinks() {
        return this.exactMatch;
    }

    @Override
    public void setSameReferenceLinks(List<LabelledResource> uris) {
        this.exactMatch = uris;
    }
}

