/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.utils;

import eu.europeana.entitymanagement.definitions.exceptions.EntityManagementRuntimeException;
import eu.europeana.entitymanagement.definitions.exceptions.EntityModelCreationException;
import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.definitions.model.Concept;
import eu.europeana.entitymanagement.definitions.model.ConsolidatedAgent;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.schemaorg.model.SchemaOrgAgent;
import eu.europeana.entitymanagement.schemaorg.model.SchemaOrgConcept;
import eu.europeana.entitymanagement.schemaorg.model.SchemaOrgEntity;
import eu.europeana.entitymanagement.schemaorg.model.SchemaOrgOrganization;
import eu.europeana.entitymanagement.schemaorg.model.SchemaOrgPlace;
import eu.europeana.entitymanagement.schemaorg.model.SchemaOrgTimeSpan;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.xml.model.XmlAgentImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlConceptImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlOrganizationImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlPlaceImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlTimeSpanImpl;
import java.util.Map;

public class EntityObjectFactory {
    private static final Map<EntityTypes, Class<? extends Entity>> consolidatedEntityTypesClassMap = Map.of(EntityTypes.Agent, ConsolidatedAgent.class, EntityTypes.Concept, Concept.class, EntityTypes.Organization, Organization.class, EntityTypes.Place, Place.class, EntityTypes.TimeSpan, TimeSpan.class);
    private static final Map<EntityTypes, Class<? extends Entity>> proxyEntityTypesClassMap = Map.of(EntityTypes.Agent, Agent.class, EntityTypes.Concept, Concept.class, EntityTypes.Organization, Organization.class, EntityTypes.Place, Place.class, EntityTypes.TimeSpan, TimeSpan.class);
    private static final Map<EntityTypes, Class<? extends XmlBaseEntityImpl<?>>> xmlEntityMap = Map.of(EntityTypes.Agent, XmlAgentImpl.class, EntityTypes.Concept, XmlConceptImpl.class, EntityTypes.Organization, XmlOrganizationImpl.class, EntityTypes.Place, XmlPlaceImpl.class, EntityTypes.TimeSpan, XmlTimeSpanImpl.class);

    private static <T extends Entity> T instantiateEntityObject(Map<EntityTypes, Class<? extends Entity>> entityMap, EntityTypes entityType) throws EntityModelCreationException {
        try {
            Class<? extends Entity> entityClass = entityMap.get(entityType);
            return (T)entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new EntityModelCreationException("Error creating instance for " + entityType.toString(), e);
        }
    }

    public static <T extends Entity> T createProxyEntityObject(String entityType) throws EntityModelCreationException {
        return EntityObjectFactory.instantiateEntityObject(proxyEntityTypesClassMap, EntityTypes.valueOf(entityType));
    }

    public static <T extends Entity> T createConsolidatedEntityObject(String entityType) throws EntityModelCreationException {
        return EntityObjectFactory.instantiateEntityObject(consolidatedEntityTypesClassMap, EntityTypes.valueOf(entityType));
    }

    public static <T extends Entity> T createConsolidatedEntityObject(Entity entity) throws EntityModelCreationException {
        try {
            Class<? extends Entity> consolidatedEntityClass = consolidatedEntityTypesClassMap.get(EntityTypes.valueOf(entity.getType()));
            switch (EntityTypes.valueOf(entity.getType())) {
                case Place: {
                    return (T)consolidatedEntityClass.getDeclaredConstructor(consolidatedEntityClass).newInstance((Place)entity);
                }
                case Agent: {
                    return (T)consolidatedEntityClass.getDeclaredConstructor(Agent.class).newInstance((Agent)entity);
                }
                case Concept: {
                    return (T)consolidatedEntityClass.getDeclaredConstructor(consolidatedEntityClass).newInstance((Concept)entity);
                }
                case Organization: {
                    return (T)consolidatedEntityClass.getDeclaredConstructor(consolidatedEntityClass).newInstance((Organization)entity);
                }
                case TimeSpan: {
                    return (T)consolidatedEntityClass.getDeclaredConstructor(consolidatedEntityClass).newInstance((TimeSpan)entity);
                }
            }
            throw new EntityManagementRuntimeException(String.format("Encountered invalid entityType %s in entityId=%s", entity.getType(), entity.getEntityId()));
        }
        catch (Exception e) {
            throw new EntityModelCreationException("Error when creating consolidated copy from entity " + entity.getEntityId(), e);
        }
    }

    public static <T extends Entity> SchemaOrgEntity<T> createSchemaOrgEntity(Entity entity) {
        switch (EntityTypes.valueOf(entity.getType())) {
            case Place: {
                return new SchemaOrgPlace((Place)entity);
            }
            case Agent: {
                return new SchemaOrgAgent((Agent)entity);
            }
            case Concept: {
                return new SchemaOrgConcept((Concept)entity);
            }
            case Organization: {
                return new SchemaOrgOrganization((Organization)entity);
            }
            case TimeSpan: {
                return new SchemaOrgTimeSpan((TimeSpan)entity);
            }
        }
        throw new EntityManagementRuntimeException(String.format("Encountered invalid entityType %s in entityId=%s", entity.getType(), entity.getEntityId()));
    }

    public static <T extends XmlBaseEntityImpl<?>> T createXmlEntity(Entity entity) throws EntityManagementRuntimeException {
        switch (EntityTypes.valueOf(entity.getType())) {
            case Agent: {
                return (T)new XmlAgentImpl((Agent)entity);
            }
            case Place: {
                return (T)new XmlPlaceImpl((Place)entity);
            }
            case Concept: {
                return (T)new XmlConceptImpl((Concept)entity);
            }
            case TimeSpan: {
                return (T)new XmlTimeSpanImpl((TimeSpan)entity);
            }
            case Organization: {
                return (T)new XmlOrganizationImpl((Organization)entity);
            }
        }
        throw new EntityManagementRuntimeException(String.format("Encountered invalid entityType %s in entityId=%s", entity.getType(), entity.getEntityId()));
    }

    public static Entity createNewEntity(Entity entity) throws EntityManagementRuntimeException {
        switch (EntityTypes.valueOf(entity.getType())) {
            case Agent: {
                return new Agent((Agent)entity);
            }
            case Place: {
                return new Place((Place)entity);
            }
            case Concept: {
                return new Concept((Concept)entity);
            }
            case TimeSpan: {
                return new TimeSpan((TimeSpan)entity);
            }
            case Organization: {
                return new Organization((Organization)entity);
            }
        }
        throw new EntityManagementRuntimeException(String.format("Encountered invalid entityType %s in entityId=%s", entity.getType(), entity.getEntityId()));
    }
}

