/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.utils;

import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.utils.EntityUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityComparator
implements Comparator<Entity>,
Serializable {
    private static final long serialVersionUID = 4897357254139647262L;
    private static final Logger LOGGER = LogManager.getLogger(EntityComparator.class);
    private static final String MAP_ERROR_MESSAGE = "Map 2 contains different values for key {}!";

    @Override
    public int compare(Entity e1, Entity e2) {
        if (this.compareClass(e1, e2) > 0) {
            return 1;
        }
        try {
            return this.compareContent(e1, e2);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("During the comparison of the entity objects an illegal or inappropriate argument has been passed to some method.", (Throwable)e);
            return 1;
        }
        catch (IllegalAccessException e) {
            LOGGER.error("During the comparison of the entity objects an illegal access to some field has been detected.", (Throwable)e);
            return 1;
        }
    }

    int compareClass(Object e1, Object e2) {
        if (e1 == null && e2 == null) {
            return 0;
        }
        if (e1 == null || e2 == null) {
            return 1;
        }
        if (!e1.getClass().equals(e2.getClass())) {
            return 1;
        }
        return 0;
    }

    int compareContent(Entity e1, Entity e2) throws IllegalAccessException {
        List<Field> allObjectFieldsE1 = EntityUtils.getAllFields(e1.getClass());
        for (Field field : allObjectFieldsE1) {
            if (field.getName().startsWith("tmp")) continue;
            return this.compareEntityField(e1, e2, field);
        }
        return 0;
    }

    private int compareEntityField(Entity e1, Entity e2, Field field) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            Object[] array2;
            Object[] array1 = (Object[])e1.getFieldValue(field);
            if (this.compareArrays(array1, array2 = (Object[])e2.getFieldValue(field)) > 0) {
                return this.getCompareResult(field);
            }
        } else if (Map.class.isAssignableFrom(fieldType)) {
            Map map2;
            Map map1 = (Map)e1.getFieldValue(field);
            if (this.compareMaps(map1, map2 = (Map)e2.getFieldValue(field)) > 0) {
                return this.getCompareResult(field);
            }
        } else if (List.class.isAssignableFrom(fieldType)) {
            List list2;
            List list1 = (List)e1.getFieldValue(field);
            if (this.compareLists(list1, list2 = (List)e2.getFieldValue(field)) > 0) {
                return this.getCompareResult(field);
            }
        } else {
            Object obj2;
            Object obj1 = e1.getFieldValue(field);
            if (this.compareClass(obj1, obj2 = e2.getFieldValue(field)) > 0) {
                return this.getCompareResult(field);
            }
            if (obj1 != null && !obj1.equals(obj2)) {
                this.getCompareResult(field);
            }
        }
        return 0;
    }

    private int getCompareResult(Field field) {
        LOGGER.trace("The values of the field {} are not equal!", (Object)field.getName());
        return 1;
    }

    int compareArrays(Object[] array1, Object[] array2) {
        List<Object> list1 = null;
        List<Object> list2 = null;
        if (array1 != null) {
            list1 = Arrays.asList(array1);
        }
        if (array2 != null) {
            list2 = Arrays.asList(array2);
        }
        return this.compareLists(list1, list2);
    }

    private int compareLists(List<Object> l1, List<Object> l2) {
        if (CollectionUtils.isEmpty(l1) && CollectionUtils.isEmpty(l2)) {
            return 0;
        }
        if (CollectionUtils.isEmpty(l1) || CollectionUtils.isEmpty(l2)) {
            return 1;
        }
        if (l1.size() != l2.size()) {
            LOGGER.trace("List size is not equal l1 size:{}, l2 size;{}!", (Object)l1.size(), (Object)l2.size());
            return 1;
        }
        for (Object l1Elem : l1) {
            if (l2.contains(l1Elem)) continue;
            LOGGER.trace("List doesn't contain element:{}", l1Elem);
            return 1;
        }
        return 0;
    }

    private int compareMaps(Map<Object, Object> m1, Map<Object, Object> m2) {
        if (MapUtils.isEmpty(m1) && MapUtils.isEmpty(m2)) {
            return 0;
        }
        if (MapUtils.isEmpty(m1) || MapUtils.isEmpty(m2)) {
            return 1;
        }
        if (m1.size() != m2.size()) {
            LOGGER.trace("Map size is not equal m1 size:{}, m2 size;{}!", (Object)m1.size(), (Object)m2.size());
            return 1;
        }
        return this.getMapResults(m1, m2);
    }

    private int getMapResults(Map<Object, Object> m1, Map<Object, Object> m2) {
        for (Map.Entry<Object, Object> m1Elem : m1.entrySet()) {
            if (m2.containsKey(m1Elem.getKey())) {
                Object val1 = m1Elem.getValue();
                Object val2 = m2.get(m1Elem.getKey());
                if (List.class.isAssignableFrom(val1.getClass())) {
                    if (this.compareLists((List)val1, (List)val2) <= 0) continue;
                    LOGGER.trace(MAP_ERROR_MESSAGE, m1Elem.getKey());
                    return 1;
                }
                if (val1.equals(val2)) continue;
                LOGGER.trace(MAP_ERROR_MESSAGE, m1Elem.getKey());
                return 1;
            }
            LOGGER.trace("Map 2 doesn't contain key {}!", m1Elem.getKey());
            return 1;
        }
        return 0;
    }
}

