/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.utils;

import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import org.apache.commons.lang3.StringUtils;

public class EntityRecordUtils {
    public static final String ENTITY_ID_REMOVED_MSG = "Entity '%s' has been removed";

    private EntityRecordUtils() {
    }

    public static String buildEntityIdUri(EntityTypes type, String identifier) {
        return EntityRecordUtils.buildEntityIdUri(type.getUrlPath(), identifier);
    }

    private static String buildEntityIdUri(String type, String identifier) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://data.europeana.eu/");
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            stringBuilder.append(type.toLowerCase()).append("/");
        }
        if (StringUtils.isNotEmpty((CharSequence)identifier)) {
            stringBuilder.append(identifier);
        }
        return stringBuilder.toString();
    }

    public static String extractIdentifierFromEntityId(String entityId) {
        return entityId.replace("http://data.europeana.eu/", "");
    }

    public static String getEuropeanaAggregationId(String entityId) {
        return entityId + "#aggr_europeana";
    }

    public static String getDatasourceAggregationId(String entityId, int aggregationId) {
        return entityId + "#aggr_source_" + aggregationId;
    }

    public static String getIsAggregatedById(String entityId) {
        return entityId + "#aggregation";
    }

    public static String getEuropeanaProxyId(String entityId) {
        return entityId + "#proxy_europeana";
    }

    public static String getIdFromUrl(String url) {
        if (!url.contains("/")) {
            return url;
        }
        String[] uriParts = url.split("/");
        return uriParts[uriParts.length - 1];
    }

    public static String getEntityRequestPath(String entityId) {
        String[] parts = entityId.split("/");
        return parts[parts.length - 2] + "/" + parts[parts.length - 1];
    }

    public static String getEntityRequestPathWithBase(String entityId) {
        String[] parts = entityId.split("/");
        return parts[parts.length - 2] + "/base/" + parts[parts.length - 1];
    }
}

