/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.Transient;
import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.EntityRecord;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.definitions.model.Vocabulary;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"@context", "id", "type", "depiction", "prefLabel", "acronym", "altLabel", "hiddenLabel", "description", "logo", "europeanaRole", "country", "language", "homepage", "phone", "mbox", "hasAddress", "identifier", "sameAs"})
public class Organization
extends Entity {
    private String type = EntityTypes.Organization.getEntityType();
    private Map<String, String> description;
    private Map<String, List<String>> acronym;
    private WebResource logo;
    private String homepage;
    private List<String> phone;
    private List<String> mbox;
    @Reference(lazy=true)
    private EntityRecord countryRef;
    private String countryId;
    @Transient
    private Place country;
    private List<String> europeanaRoleIds;
    @Reference(lazy=true)
    private List<Vocabulary> europeanaRoleRefs;
    @Transient
    private List<Vocabulary> europeanaRole;
    private Address hasAddress;
    private List<String> sameAs;
    private List<String> language;

    public Organization() {
    }

    public Organization(Organization copy) {
        super(copy);
        if (copy.getDescription() != null) {
            this.description = new HashMap<String, String>(copy.getDescription());
        }
        if (copy.getAcronym() != null) {
            this.acronym = new HashMap<String, List<String>>(copy.getAcronym());
        }
        this.logo = copy.getLogo();
        this.homepage = copy.getHomepage();
        if (copy.getPhone() != null) {
            this.phone = new ArrayList<String>(copy.getPhone());
        }
        if (copy.getMbox() != null) {
            this.mbox = new ArrayList<String>(copy.getMbox());
        }
        this.europeanaRoleRefs = copy.getEuropeanaRoleRefs();
        if (copy.getEuropeanaRoleIds() != null) {
            this.europeanaRoleIds = new ArrayList<String>(copy.getEuropeanaRoleIds());
        }
        this.countryRef = copy.getCountryRef();
        this.countryId = copy.getCountryId();
        this.country = copy.getCountry();
        if (copy.getAddress() != null) {
            this.hasAddress = new Address(copy.getAddress());
        }
        if (copy.sameAs != null) {
            this.sameAs = new ArrayList<String>(copy.sameAs);
        }
        if (copy.language != null) {
            this.language = new ArrayList<String>(copy.language);
        }
    }

    @JsonGetter(value="description")
    public Map<String, String> getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(Map<String, String> dcDescription) {
        this.description = dcDescription;
    }

    @JsonGetter(value="acronym")
    public Map<String, List<String>> getAcronym() {
        return this.acronym;
    }

    @JsonSetter(value="acronym")
    public void setAcronym(Map<String, List<String>> acronym) {
        this.acronym = acronym;
    }

    @JsonGetter(value="phone")
    public List<String> getPhone() {
        return this.phone;
    }

    @JsonSetter(value="phone")
    public void setPhone(List<String> phone) {
        this.phone = phone;
    }

    @JsonGetter(value="mbox")
    public List<String> getMbox() {
        return this.mbox;
    }

    @JsonSetter(value="mbox")
    public void setMbox(List<String> mbox) {
        this.mbox = mbox;
    }

    @JsonGetter(value="hasAddress")
    public Address getAddress() {
        return this.hasAddress;
    }

    @JsonSetter(value="hasAddress")
    public void setAddress(Address hasAddress) {
        this.hasAddress = hasAddress;
    }

    @JsonGetter(value="homepage")
    public String getHomepage() {
        return this.homepage;
    }

    @JsonSetter(value="homepage")
    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    @JsonGetter(value="logo")
    public WebResource getLogo() {
        return this.logo;
    }

    @JsonSetter(value="logo")
    public void setLogo(WebResource logo) {
        this.logo = logo;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Object getFieldValue(Field field) throws IllegalAccessException {
        return field.get(this);
    }

    @Override
    @JsonSetter(value="sameAs")
    public void setSameReferenceLinks(List<String> uris) {
        this.sameAs = uris;
    }

    @Override
    @JsonGetter(value="sameAs")
    public List<String> getSameReferenceLinks() {
        return this.sameAs;
    }

    @Override
    public void setFieldValue(Field field, Object value) throws IllegalAccessException {
        field.set(this, value);
    }

    @JsonGetter(value="language")
    public List<String> getLanguage() {
        return this.language;
    }

    @JsonSetter(value="language")
    public void setLanguage(List<String> edmLanguage) {
        this.language = edmLanguage;
    }

    @JsonIgnore
    public EntityRecord getCountryRef() {
        return this.countryRef;
    }

    public void setCountryRef(EntityRecord countryRef) {
        this.countryRef = countryRef;
    }

    @JsonGetter(value="country")
    public Place getCountry() {
        if (this.country == null && this.getCountryId() != null) {
            this.country = new Place(this.getCountryId());
        } else if (this.country != null) {
            this.country.setContext(null);
        }
        return this.country;
    }

    @JsonSetter(value="country")
    public void setCountry(Place country) {
        this.country = country;
    }

    @JsonIgnore
    public String getCountryId() {
        return this.countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    @JsonIgnore
    public List<String> getEuropeanaRoleIds() {
        return this.europeanaRoleIds;
    }

    public void setEuropeanaRoleIds(List<String> europeanaRoleIds) {
        this.europeanaRoleIds = europeanaRoleIds;
    }

    @JsonIgnore
    public List<Vocabulary> getEuropeanaRoleRefs() {
        return this.europeanaRoleRefs;
    }

    public void setEuropeanaRoleRefs(List<Vocabulary> europeanaRoleRefs) {
        this.europeanaRoleRefs = europeanaRoleRefs;
    }

    @JsonGetter(value="europeanaRole")
    public List<Vocabulary> getEuropeanaRole() {
        if (this.europeanaRole == null && this.europeanaRoleIds != null && !this.europeanaRoleIds.isEmpty()) {
            this.europeanaRole = new ArrayList<Vocabulary>();
            for (String roleId : this.europeanaRoleIds) {
                Vocabulary vocab = new Vocabulary();
                vocab.setId(roleId);
                this.europeanaRole.add(vocab);
            }
        }
        return this.europeanaRole;
    }

    @JsonSetter(value="europeanaRole")
    public void setEuropeanaRole(List<Vocabulary> europeanaRole) {
        this.europeanaRole = europeanaRole;
    }
}

