/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.entitymanagement.definitions.exceptions.EntityModelCreationException;
import eu.europeana.entitymanagement.definitions.model.Organization;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import eu.europeana.entitymanagement.web.xml.model.RdfXmlUtils;
import eu.europeana.entitymanagement.web.xml.model.XmlAddressImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlAddresses;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlWebResourceWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;

@XmlRootElement(namespace="http://www.europeana.eu/schemas/edm/", name="Organization")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"about", "depiction", "isShownBy", "prefLabel", "altLabel", "hiddenLabel", "acronym", "description", "logo", "europeanaRole", "organizationDomain", "geographicLevel", "country", "language", "homepage", "phone", "mbox", "hasAddress", "identifier", "sameAs", "isAggregatedBy"})
public class XmlOrganizationImpl
extends XmlBaseEntityImpl<Organization> {
    @XmlElement(namespace="http://www.w3.org/2002/07/owl#", name="sameAs")
    private List<LabelledResource> sameAs = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="acronym")
    private List<LabelledResource> acronym = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://purl.org/dc/elements/1.1/", name="description")
    private List<LabelledResource> description = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://xmlns.com/foaf/0.1/", name="logo")
    private XmlWebResourceWrapper logo;
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="europeanaRole")
    private List<LabelledResource> europeanaRole = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="organizationDomain")
    private List<LabelledResource> organizationDomain = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="geographicLevel")
    private List<LabelledResource> geographicLevel = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="country")
    private String country;
    @XmlElement(namespace="http://xmlns.com/foaf/0.1/", name="homepage")
    private LabelledResource homepage;
    @XmlElement(namespace="http://xmlns.com/foaf/0.1/", name="phone")
    private List<String> phone;
    @XmlElement(namespace="http://xmlns.com/foaf/0.1/", name="mbox")
    private List<String> mbox;
    @XmlElement(namespace="http://www.w3.org/2006/vcard/ns#", name="hasAddress")
    private XmlAddresses hasAddress;
    @XmlElement(namespace="http://purl.org/dc/elements/1.1/", name="identifier")
    private List<String> identifier;
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="language")
    private List<String> language;

    public XmlOrganizationImpl(Organization organization) {
        super(organization);
        this.sameAs = RdfXmlUtils.convertToRdfResource(organization.getSameReferenceLinks());
        this.acronym = RdfXmlUtils.convertToXmlMultilingualString(organization.getAcronym());
        this.description = RdfXmlUtils.convertMapToXmlMultilingualString(organization.getDescription());
        if (organization.getLogo() != null) {
            this.logo = XmlWebResourceWrapper.fromWebResource(organization.getLogo());
        }
        this.europeanaRole = RdfXmlUtils.convertToXmlMultilingualString(organization.getEuropeanaRole());
        this.organizationDomain = RdfXmlUtils.convertToXmlMultilingualString(organization.getOrganizationDomain());
        this.geographicLevel = RdfXmlUtils.convertMapToXmlMultilingualString(organization.getGeographicLevel());
        this.country = organization.getCountry();
        if (organization.getHomepage() != null) {
            this.homepage = new LabelledResource(organization.getHomepage());
        }
        if (organization.getPhone() != null) {
            this.phone = new ArrayList<String>(organization.getPhone());
        }
        if (organization.getMbox() != null) {
            this.mbox = new ArrayList<String>(organization.getMbox());
        }
        if (organization.getAddress() != null) {
            this.hasAddress = new XmlAddresses(List.of(new XmlAddressImpl(organization.getAddress())));
        }
        if (organization.getIdentifier() != null) {
            this.identifier = new ArrayList<String>(organization.getIdentifier());
        }
        if (organization.getLanguage() != null) {
            this.language = new ArrayList<String>(organization.getLanguage());
        }
    }

    @Override
    public Organization toEntityModel() throws EntityModelCreationException {
        super.toEntityModel();
        ((Organization)this.entity).setAcronym(RdfXmlUtils.toLanguageMapList(this.getAcronym()));
        ((Organization)this.entity).setDescription(RdfXmlUtils.toLanguageMap(this.getDescription()));
        ((Organization)this.entity).setLogo(XmlWebResourceWrapper.toWebResource(this.getLogo()));
        ((Organization)this.entity).setEuropeanaRole(RdfXmlUtils.toLanguageMapList(this.getEuropeanaRole()));
        ((Organization)this.entity).setOrganizationDomain(RdfXmlUtils.toLanguageMapList(this.getOrganizationDomain()));
        ((Organization)this.entity).setGeographicLevel(RdfXmlUtils.toLanguageMap(this.getGeographicLevel()));
        ((Organization)this.entity).setCountry(this.getCountry());
        if (this.getHomepage() != null) {
            ((Organization)this.entity).setHomepage(this.getHomepage().getResource());
        }
        ((Organization)this.entity).setPhone(this.getPhone());
        ((Organization)this.entity).setMbox(this.getMbox());
        if (this.hasAddress != null && !CollectionUtils.isEmpty(this.hasAddress.getVcardAddressesList()) && this.hasAddress.getVcardAddressesList().get(0).hasMetadataProperties()) {
            ((Organization)this.entity).setAddress(this.hasAddress.getVcardAddressesList().get(0).toAddress());
        }
        ((Organization)this.entity).setIdentifier(this.getIdentifier());
        ((Organization)this.entity).setLanguage(this.getLanguage());
        return (Organization)this.entity;
    }

    public XmlOrganizationImpl() {
    }

    public List<LabelledResource> getAcronym() {
        return this.acronym;
    }

    public List<LabelledResource> getDescription() {
        return this.description;
    }

    public XmlWebResourceWrapper getLogo() {
        return this.logo;
    }

    public List<LabelledResource> getEuropeanaRole() {
        return this.europeanaRole;
    }

    public List<LabelledResource> getOrganizationDomain() {
        return this.organizationDomain;
    }

    public List<LabelledResource> getGeographicLevel() {
        return this.geographicLevel;
    }

    public String getCountry() {
        return this.country;
    }

    public LabelledResource getHomepage() {
        return this.homepage;
    }

    public List<String> getPhone() {
        return this.phone;
    }

    public List<String> getMbox() {
        return this.mbox;
    }

    public List<String> getIdentifier() {
        return this.identifier;
    }

    public XmlAddresses getHasAddress() {
        return this.hasAddress;
    }

    @Override
    protected EntityTypes getTypeEnum() {
        return EntityTypes.Organization;
    }

    @Override
    public List<LabelledResource> getSameReferenceLinks() {
        return this.sameAs;
    }

    @Override
    public void setSameReferenceLinks(List<LabelledResource> uris) {
        this.sameAs = uris;
    }

    public List<String> getLanguage() {
        return this.language;
    }
}

