/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.normalization;

import eu.europeana.entitymanagement.definitions.LanguageCodes;
import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.utils.UriValidator;
import eu.europeana.entitymanagement.vocabulary.EntityFieldsTypes;
import eu.europeana.entitymanagement.vocabulary.ValidationObject;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class EntityFieldsDatatypeValidation {
    private final LanguageCodes emLanguageCodes;

    public EntityFieldsDatatypeValidation(LanguageCodes emLanguageCodes) {
        this.emLanguageCodes = emLanguageCodes;
    }

    public boolean validateStringValue(ConstraintValidatorContext context, String fieldName, String fieldInternalType, String fieldValue, String key) {
        if (!fieldValue.equals(fieldValue.trim())) {
            this.addConstraint(context, "The entity field: " + fieldName + ", contains leading and/or trailing spaces: " + fieldValue + ".");
            return false;
        }
        boolean isUriRequired = this.isUriRequired(key, fieldInternalType);
        boolean isUriValue = UriValidator.isUri(fieldValue);
        if (isUriRequired && !isUriValue) {
            this.addInvalidUriConstraint(context, fieldName, fieldInternalType, fieldValue);
            return false;
        }
        if (isUriValue && !isUriRequired) {
            this.addUriNotAllowedConstraint(context, fieldName, fieldValue, key);
            return false;
        }
        return true;
    }

    private void addUriNotAllowedConstraint(ConstraintValidatorContext context, String fieldName, String fieldValue, String key) {
        String messageTemplate = "The entity field '" + fieldName + "' must not contain URI: " + fieldValue + ".";
        if (key != null) {
            messageTemplate = messageTemplate + " for key: " + key;
        }
        this.addConstraint(context, messageTemplate);
    }

    public boolean validateEmailField(ConstraintValidatorContext context, String fieldName, Class<?> fieldJavaType, Object fieldValue) {
        boolean returnValue = true;
        if (fieldJavaType.isAssignableFrom(ArrayList.class)) {
            returnValue = this.validateEmailListField(context, fieldName, (List)fieldValue);
        } else if (fieldJavaType.isAssignableFrom(String.class)) {
            returnValue = this.checkEmailFormat(context, fieldName, (String)fieldValue);
        }
        return returnValue;
    }

    private boolean validateEmailListField(ConstraintValidatorContext context, String fieldName, List<String> fieldValues) {
        boolean returnValue = true;
        if (fieldValues.isEmpty()) {
            return true;
        }
        if (this.hasFieldCardinalityViolation(context, fieldName, fieldValues)) {
            return false;
        }
        for (String fieldValueElem : fieldValues) {
            boolean returnValueLocal = this.checkEmailFormat(context, fieldName, fieldValueElem);
            returnValue = returnValue && returnValueLocal;
        }
        return returnValue;
    }

    private boolean validateWebResourceField(ConstraintValidatorContext context, String fieldName, WebResource webResource) {
        boolean isValid = true;
        if (webResource.getId() == null || !this.validateUri(context, fieldName, EntityFieldsTypes.getFieldType(fieldName), webResource.getId())) {
            this.addConstraint(context, "Field '" + fieldName + "' has an invalid or empty id value.");
            isValid = false;
        }
        if (webResource.getSource() == null || !this.validateUri(context, fieldName, EntityFieldsTypes.getFieldType(fieldName), webResource.getSource())) {
            this.addConstraint(context, "Field '" + fieldName + "' has an invalid or empty source value.");
            isValid = false;
        }
        if (StringUtils.isNotEmpty((CharSequence)webResource.getThumbnail()) && !this.validateUri(context, fieldName, EntityFieldsTypes.getFieldType(fieldName), webResource.getThumbnail())) {
            this.addConstraint(context, "Field '" + fieldName + "' has an invalid or empty thumbnail value.");
            isValid = false;
        }
        return isValid;
    }

    private boolean validateAddressField(ConstraintValidatorContext context, String fieldName, Address address) {
        boolean isValid = true;
        if (address.getAbout() == null || !this.validateUri(context, fieldName, EntityFieldsTypes.getFieldType(fieldName), address.getAbout())) {
            this.addConstraint(context, "Field '" + fieldName + "' has an invalid or empty id value.");
            isValid = false;
        }
        if (address.getVcardCountryName() == null || address.getVcardCountryName().isBlank() || !this.validateStringValue(context, fieldName, EntityFieldsTypes.getFieldType(fieldName), address.getVcardCountryName(), null)) {
            this.addConstraint(context, "Field '" + fieldName + "' has an invalid or empty country name.");
            isValid = false;
        }
        return isValid;
    }

    private boolean hasFieldCardinalityViolation(ConstraintValidatorContext context, String fieldName, List<String> fieldValues) {
        if (EntityFieldsTypes.isSingleValueField(fieldName) && fieldValues.size() > 1) {
            this.addConstraint(context, "The entity field '" + fieldName + "' cannot have more than one value");
            return true;
        }
        return false;
    }

    private boolean checkEmailFormat(ConstraintValidatorContext context, String fieldName, String fieldValue) {
        EmailValidator validator = EmailValidator.getInstance();
        if (validator.isValid(fieldValue)) {
            return true;
        }
        this.addConstraint(context, "The entity field '" + fieldName + "' is of type Email and contains inappropriate characters: " + fieldValue + ".");
        return false;
    }

    public boolean validateDateField(ConstraintValidatorContext context, String fieldName, Class<?> fieldJavaType, Object fieldValue) {
        boolean returnValue = true;
        if (fieldJavaType.isAssignableFrom(ArrayList.class)) {
            returnValue = this.validateDateListField(context, fieldName, (List)fieldValue);
        } else if (fieldJavaType.isAssignableFrom(String.class)) {
            returnValue = this.checkDateFormatISO8601(context, fieldName, (String)fieldValue);
        }
        return returnValue;
    }

    private boolean validateDateListField(ConstraintValidatorContext context, String fieldName, List<String> fieldValues) {
        boolean isValid = true;
        if (fieldValues.isEmpty()) {
            return true;
        }
        if (this.hasFieldCardinalityViolation(context, fieldName, fieldValues)) {
            return false;
        }
        for (String fieldValueElem : fieldValues) {
            isValid = isValid && this.checkDateFormatISO8601(context, fieldName, fieldValueElem);
        }
        return isValid;
    }

    private boolean checkDateFormatISO8601(ConstraintValidatorContext context, String fieldName, String fieldValue) {
        try {
            if (fieldValue.contains("T")) {
                LocalDate.parse(fieldValue, DateTimeFormatter.ISO_DATE_TIME);
            } else {
                LocalDate.parse(fieldValue, DateTimeFormatter.ISO_DATE);
            }
            return true;
        }
        catch (DateTimeParseException e) {
            this.addConstraint(context, "The entity field '" + fieldName + "' is of type Date and does not comply with the ISO-8601 format: " + fieldValue + ".");
            return false;
        }
    }

    public boolean validateURIField(ConstraintValidatorContext context, String fieldName, Class<?> fieldJavaType, Object fieldValue) {
        boolean returnValue = true;
        if (fieldJavaType.isAssignableFrom(ArrayList.class)) {
            returnValue = this.validateURIListField(context, fieldName, (List)fieldValue);
        } else if (fieldJavaType.isAssignableFrom(String.class)) {
            returnValue = this.validateUri(context, fieldName, EntityFieldsTypes.getFieldType(fieldName), (String)fieldValue);
        }
        return returnValue;
    }

    private boolean validateURIListField(ConstraintValidatorContext context, String fieldName, List<String> fieldValues) {
        boolean returnValue = true;
        if (fieldValues.isEmpty()) {
            return true;
        }
        if (this.hasFieldCardinalityViolation(context, fieldName, fieldValues)) {
            return false;
        }
        for (String fieldValueElem : fieldValues) {
            if (this.validateUri(context, fieldName, EntityFieldsTypes.getFieldType(fieldName), fieldValueElem)) continue;
            returnValue = false;
        }
        return returnValue;
    }

    private boolean validateUri(ConstraintValidatorContext context, String fieldName, String fieldInternalType, String fieldValue) {
        if (!UriValidator.isUri(fieldValue)) {
            this.addInvalidUriConstraint(context, fieldName, fieldInternalType, fieldValue);
            return false;
        }
        return true;
    }

    private void addInvalidUriConstraint(ConstraintValidatorContext context, String fieldName, String fieldInternalType, String fieldValue) {
        this.addConstraint(context, "The entity field '" + fieldName + "' is of type: " + fieldInternalType + " but the value it contains: " + fieldValue + " does not have the proper URI form.");
    }

    public boolean validateMultilingualField(ConstraintValidatorContext context, String fieldName, String fieldInternalType, Object fieldValue) {
        Map fieldValueMap = (Map)fieldValue;
        if (fieldValueMap.isEmpty()) {
            return true;
        }
        boolean returnValue = this.validateLanguageCodes(context, fieldName, fieldValueMap.keySet());
        boolean definitionIsList = EntityFieldsTypes.isListOrMap(fieldName);
        for (Map.Entry fieldValueMapElem : fieldValueMap.entrySet()) {
            boolean localReturnValue;
            boolean valueIsList = fieldValueMapElem.getValue().getClass().isAssignableFrom(ArrayList.class);
            if (definitionIsList) {
                if (!valueIsList) {
                    this.addConstraint(context, "The entity field '" + fieldName + "' cardinality: " + EntityFieldsTypes.getFieldCardinality(fieldName) + " and must be represented as list");
                    localReturnValue = false;
                    continue;
                }
                List values = (List)fieldValueMapElem.getValue();
                for (String multilingualValue : values) {
                    localReturnValue = this.validateMultilingualValue(context, fieldName, (String)fieldValueMapElem.getKey(), multilingualValue, fieldInternalType);
                    returnValue = returnValue && localReturnValue;
                }
                continue;
            }
            if (valueIsList) {
                this.addConstraint(context, "The entity field '" + fieldName + "' cardinality: " + EntityFieldsTypes.getFieldCardinality(fieldName) + " and must not be represented as list");
                localReturnValue = false;
            } else {
                String multilingualValue = (String)fieldValueMapElem.getValue();
                localReturnValue = this.validateMultilingualValue(context, fieldName, (String)fieldValueMapElem.getKey(), multilingualValue, fieldInternalType);
            }
            returnValue = returnValue && localReturnValue;
        }
        return returnValue;
    }

    private boolean validateMultilingualValue(ConstraintValidatorContext context, String fieldName, String key, String multilingualValue, String fieldInternalType) {
        if (this.isUriRequired(key, fieldInternalType)) {
            return this.validateUri(context, fieldName, EntityFieldsTypes.getFieldType(fieldName), multilingualValue);
        }
        return this.validateStringValue(context, fieldName, fieldInternalType, multilingualValue, key);
    }

    private boolean validateLanguageCodes(ConstraintValidatorContext context, String fieldName, Set<String> keySet) {
        boolean isValid = true;
        for (String key : keySet) {
            if (this.emLanguageCodes.isValidLanguageCode(key) || this.emLanguageCodes.isValidAltLanguageCode(key)) continue;
            this.addConstraint(context, "The entity field '" + fieldName + "' contains the language code: " + key + " that does not belong to the Europeana language codes.");
            if (!isValid) continue;
            isValid = false;
        }
        return isValid;
    }

    private void addConstraint(ConstraintValidatorContext context, String messageTemplate) {
        context.buildConstraintViolationWithTemplate(messageTemplate).addConstraintViolation();
    }

    private boolean isUriRequired(String key, String fieldType) {
        return "".equals(key) && "Text or URI".equals(fieldType);
    }

    private boolean validateMandatoryFields(ConstraintValidatorContext context, String fieldName, Object fieldValue) {
        if (EntityFieldsTypes.isMandatory(fieldName) && fieldValue == null) {
            this.addConstraint(context, "The mandatory field: " + fieldName + " cannot be NULL.");
            return false;
        }
        int minContentCount = EntityFieldsTypes.getMinContentCount(fieldName);
        if (minContentCount > 0 && (List.class.isAssignableFrom(fieldValue.getClass()) && ((List)fieldValue).size() < minContentCount || Map.class.isAssignableFrom(fieldValue.getClass()) && ((Map)fieldValue).size() < minContentCount)) {
            this.addConstraint(context, fieldName + " must have at least " + minContentCount + " value(s)");
            return false;
        }
        return true;
    }

    private boolean validateMetadataFields(ConstraintValidatorContext context, String fieldName, Object fieldValue, Class<?> fieldType) {
        if (fieldValue == null) {
            return true;
        }
        String fieldInternalType = EntityFieldsTypes.valueOf(fieldName).getFieldType();
        if (EntityFieldsTypes.isMultilingual(fieldName)) {
            return this.validateMultilingualField(context, fieldName, fieldInternalType, fieldValue);
        }
        if ("URI".equals(EntityFieldsTypes.getFieldType(fieldName))) {
            return this.validateURIField(context, fieldName, fieldType, fieldValue);
        }
        if ("Date".equals(EntityFieldsTypes.getFieldType(fieldName))) {
            return this.validateDateField(context, fieldName, fieldType, fieldValue);
        }
        if ("Email".equals(EntityFieldsTypes.getFieldType(fieldName))) {
            return this.validateEmailField(context, fieldName, fieldType, fieldValue);
        }
        if (fieldType.isAssignableFrom(String.class) && !fieldValue.toString().isBlank()) {
            return this.validateStringValue(context, fieldName, fieldInternalType, (String)fieldValue, null);
        }
        return true;
    }

    private boolean validateMetadataObjects(ConstraintValidatorContext context, String fieldName, Object fieldValue, Class<?> fieldType) {
        if (fieldValue != null) {
            if (WebResource.class.isAssignableFrom(fieldType)) {
                return this.validateWebResourceField(context, fieldName, (WebResource)fieldValue);
            }
            if (Address.class.isAssignableFrom(fieldType)) {
                return this.validateAddressField(context, fieldName, (Address)fieldValue);
            }
        }
        return true;
    }

    public boolean validateEntity(ValidationObject entity, ConstraintValidatorContext context, boolean validateMandatoryFields, boolean validateMetadataFields) {
        if (entity == null) {
            return false;
        }
        boolean isValid = true;
        List<Field> entityFields = EntityUtils.getAllFields(entity.getClass());
        for (Field field : entityFields) {
            try {
                String fieldName = field.getName();
                if (!EntityFieldsTypes.hasTypeDefinition(fieldName)) continue;
                Object fieldValue = entity.getFieldValue(field);
                if (validateMandatoryFields) {
                    boolean bl = isValid = this.validateMandatoryFields(context, fieldName, fieldValue) && isValid;
                }
                if (validateMetadataFields) {
                    isValid = this.validateMetadataFields(context, fieldName, fieldValue, field.getType()) && isValid;
                }
                isValid = this.validateMetadataObjects(context, fieldName, fieldValue, field.getType()) && isValid;
            }
            catch (IllegalArgumentException e) {
                this.addConstraint(context, "During the validation of the entity field: " + field.getName() + ", an illegal or inappropriate argument exception has happened. The exception stack trace is:" + e.getStackTrace());
            }
            catch (IllegalAccessException e) {
                this.addConstraint(context, "During the validation of the entity field: " + field.getName() + ", an illegal access to some method or field has happened. The exception stack trace is:" + e.getStackTrace());
            }
        }
        return isValid;
    }
}

