/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.normalization;

import eu.europeana.entitymanagement.definitions.LanguageCodes;
import eu.europeana.entitymanagement.definitions.exceptions.EntityManagementRuntimeException;
import eu.europeana.entitymanagement.definitions.model.ConsolidatedAgent;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.vocabulary.EntityFieldsTypes;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityFieldsCleaner {
    private static final Set<String> ISO_LANGUAGES = Set.of(Locale.getISOLanguages());
    private static final Logger logger = LogManager.getLogger(EntityFieldsCleaner.class);
    private final LanguageCodes emLanguageCodes;
    private final String thumbnailBaseUrl;
    private final Map<Class<? extends Entity>, List<String>> SINGLE_ELEMENT_LIST_FIELDS = Map.of(ConsolidatedAgent.class, List.of("begin", "end", "dateOfBirth", "dateOfDeath", "dateOfEstablishment", "dateOfTermination", "gender"));

    public EntityFieldsCleaner(LanguageCodes emLanguageCodes, String thumbnailBaseUrl) {
        this.emLanguageCodes = emLanguageCodes;
        this.thumbnailBaseUrl = thumbnailBaseUrl;
    }

    public void cleanAndNormalize(Entity entity) {
        List<Field> entityFields = EntityUtils.getAllFields(entity.getClass());
        try {
            for (Field field : entityFields) {
                Object fieldValue = entity.getFieldValue(field);
                if (fieldValue == null) continue;
                Class<Object> fieldType = field.getType();
                if (fieldType.isAssignableFrom(String.class)) {
                    this.normalizeTextField(field, (String)fieldValue, entity);
                    continue;
                }
                if (fieldType.isAssignableFrom(String[].class)) {
                    List<String> normalizedList = this.normalizeValues(field.getName(), Arrays.asList((String[])fieldValue));
                    String[] normalized = normalizedList.toArray(new String[0]);
                    entity.setFieldValue(field, normalized);
                    continue;
                }
                if (fieldType.isAssignableFrom(List.class)) {
                    List fieldValueList = (List)fieldValue;
                    if (fieldValueList.isEmpty()) continue;
                    List<String> normalizedList = this.normalizeValues(field.getName(), fieldValueList);
                    if (this.SINGLE_ELEMENT_LIST_FIELDS.containsKey(entity.getClass()) && this.SINGLE_ELEMENT_LIST_FIELDS.get(entity.getClass()).contains(field.getName()) && normalizedList.size() > 1) {
                        normalizedList.subList(1, normalizedList.size()).clear();
                    }
                    entity.setFieldValue(field, normalizedList);
                    continue;
                }
                if (fieldType.isAssignableFrom(Map.class)) {
                    Map normalized = this.normalizeMapField(field, (Map)fieldValue);
                    entity.setFieldValue(field, normalized);
                    continue;
                }
                if (!WebResource.class.isAssignableFrom(fieldType)) continue;
                entity.setFieldValue(field, this.normalizeWebResource((WebResource)fieldValue));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new EntityManagementRuntimeException("Unexpected exception occured during the normalization and cleaning of entity metadata ", e);
        }
    }

    private WebResource normalizeWebResource(WebResource existingFieldValue) {
        WebResource webResource = new WebResource(existingFieldValue);
        if (StringUtils.isEmpty((CharSequence)webResource.getThumbnail()) && StringUtils.isNotBlank((CharSequence)webResource.getSource()) && webResource.getSource().startsWith("http://data.europeana.eu/")) {
            webResource.setThumbnail(this.thumbnailBaseUrl + URLEncoder.encode(webResource.getId(), StandardCharsets.UTF_8));
        }
        return webResource;
    }

    private Map normalizeMapField(Field field, Map fieldValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (fieldValue == null) {
            return null;
        }
        if (this.isSingleValueStringMap(field)) {
            return this.normalizeSingleValueMap(field, fieldValue);
        }
        if (this.isMultipleValueStringMap(field)) {
            return this.normalizeMultipleValueMap(field.getName(), fieldValue);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("normalization not supported for maps of type: {}", (Object)field.getGenericType());
        }
        return fieldValue;
    }

    Map<String, String> normalizeSingleValueMap(Field field, Map<String, String> singleValueMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Map normalizedMap = (Map)ConstructorUtils.invokeConstructor(singleValueMap.getClass(), (Object[])new Object[]{singleValueMap.size()});
        for (Map.Entry<String, String> mapEntry : singleValueMap.entrySet()) {
            String normalizedKey = this.normalizeMapKey(mapEntry.getKey());
            if (normalizedKey == null) continue;
            normalizedMap.put(normalizedKey, this.capitaliseTextFields(field.getName(), mapEntry.getValue()));
        }
        return normalizedMap;
    }

    private Map<String, List<String>> normalizeMultipleValueMap(String fieldName, Map<String, List<String>> singleValueMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Map normalizedMap = (Map)ConstructorUtils.invokeConstructor(singleValueMap.getClass(), (Object[])new Object[]{singleValueMap.size()});
        for (Map.Entry<String, List<String>> mapEntry : singleValueMap.entrySet()) {
            String normalizedKey = this.normalizeMapKey(mapEntry.getKey());
            if (normalizedKey == null) continue;
            List<String> normalizedValues = this.normalizeValues(fieldName, mapEntry.getValue());
            normalizedMap.put(normalizedKey, normalizedValues);
        }
        return normalizedMap;
    }

    private List<String> normalizeValues(String fieldName, List<String> values) {
        ArrayList<String> normalized;
        if (EntityFieldsTypes.getFieldType(fieldName).equals("Date")) {
            normalized = new ArrayList();
            for (String value : values) {
                String normalizedValue = this.normalizeTextValue(fieldName, value);
                normalized.add(normalizedValue);
            }
        } else {
            normalized = values.stream().map(x -> this.normalizeTextValue(fieldName, (String)x)).collect(Collectors.toList());
        }
        return normalized;
    }

    String normalizeMapKey(String key) {
        if (key == null) {
            return null;
        }
        String normalizedKey = key;
        if (key.contains(" ")) {
            normalizedKey = key.replaceAll("\\s+", "");
        }
        if (normalizedKey.length() < 2) {
            return null;
        }
        if (normalizedKey.length() == 2) {
            if (!this.emLanguageCodes.isValidLanguageCode(normalizedKey)) {
                return null;
            }
        } else {
            normalizedKey = this.emLanguageCodes.getByAlternativeCode(normalizedKey);
        }
        return normalizedKey;
    }

    private boolean isMultipleValueStringMap(Field field) {
        Type genericType = field.getGenericType();
        return genericType.getTypeName().contains("Map<java.lang.String, java.util.List<java.lang.String>>");
    }

    private boolean isSingleValueStringMap(Field field) {
        Type genericType = field.getGenericType();
        return genericType.getTypeName().contains("Map<java.lang.String, java.lang.String>");
    }

    private void normalizeTextField(Field field, String fieldValue, Entity entity) throws IllegalArgumentException, IllegalAccessException {
        String normalizedValue;
        if (fieldValue != null && !(normalizedValue = this.normalizeTextValue(field.getName(), fieldValue)).equals(fieldValue)) {
            entity.setFieldValue(field, normalizedValue);
        }
    }

    String normalizeTextValue(String fieldName, String fieldValue) {
        if (fieldValue != null) {
            String normalizedValue = this.capitaliseTextFields(fieldName, fieldValue);
            if (EntityFieldsTypes.getFieldType(fieldName).equals("Date")) {
                normalizedValue = this.convertDatetimeToDate(normalizedValue);
            }
            if (fieldValue != normalizedValue) {
                return normalizedValue;
            }
        }
        return fieldValue;
    }

    String convertDatetimeToDate(String fieldValue) {
        try {
            if (fieldValue.contains("T")) {
                return LocalDate.parse(fieldValue, DateTimeFormatter.ISO_DATE_TIME).toString();
            }
        }
        catch (DateTimeParseException e) {
            return fieldValue;
        }
        return fieldValue;
    }

    private String capitaliseTextFields(String fieldName, String fieldValue) {
        if (!ISO_LANGUAGES.contains(fieldValue)) {
            if (EntityFieldsTypes.getFieldType(fieldName).equals("Text")) {
                return StringUtils.capitalize((String)fieldValue.trim());
            }
            if (EntityFieldsTypes.getFieldType(fieldName).equals("Text or URI") && !StringUtils.startsWithAny((CharSequence)fieldValue, (CharSequence[])new CharSequence[]{"https://", "http://"})) {
                return StringUtils.capitalize((String)fieldValue.trim());
            }
            if (StringUtils.equals((CharSequence)EntityFieldsTypes.getFieldType(fieldName), (CharSequence)"Keyword")) {
                return fieldValue.trim();
            }
        }
        return fieldValue.trim();
    }
}

