/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"@context", "id", "type", "depiction", "isShownBy", "prefLabel", "altLabel", "hiddenLabel", "lat", "long", "alt", "lat_long", "note", "hasPart", "isPartOf", "isNextInSequence", "sameAs", "isAggregatedBy"})
public class Place
extends Entity {
    private String type = EntityTypes.Place.getEntityType();
    private List<String> isNextInSequence;
    private Float latitude;
    private Float longitude;
    private Float altitude;
    private List<String> sameAs;

    public Place(Place copy) {
        super(copy);
        if (copy.getIsNextInSequence() != null) {
            this.isNextInSequence = new ArrayList<String>(copy.getIsNextInSequence());
        }
        this.latitude = copy.getLatitude();
        this.longitude = copy.getLongitude();
        this.altitude = copy.getAltitude();
        if (copy.sameAs != null) {
            this.sameAs = new ArrayList<String>(copy.sameAs);
        }
    }

    public Place() {
    }

    @JsonGetter(value="isNextInSequence")
    @JacksonXmlProperty(localName="edm:isNextInSequence")
    public List<String> getIsNextInSequence() {
        return this.isNextInSequence;
    }

    @JsonSetter(value="isNextInSequence")
    public void setIsNextInSequence(List<String> isNextInSequence) {
        this.isNextInSequence = isNextInSequence;
    }

    @JsonGetter(value="lat")
    @JacksonXmlProperty(localName="wgs84_pos:lat")
    public Float getLatitude() {
        return this.latitude;
    }

    @JsonSetter(value="lat")
    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    @JsonGetter(value="long")
    @JacksonXmlProperty(localName="wgs84_pos:long")
    public Float getLongitude() {
        return this.longitude;
    }

    @JsonSetter(value="long")
    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    @JsonGetter(value="alt")
    @JacksonXmlProperty(localName="wgs84_pos:alt")
    public Float getAltitude() {
        return this.altitude;
    }

    @JsonSetter(value="alt")
    public void setAltitude(Float altitude) {
        this.altitude = altitude;
    }

    @Override
    @JsonSetter(value="sameAs")
    public void setSameReferenceLinks(List<String> uris) {
        this.sameAs = uris;
    }

    @Override
    @JsonGetter(value="sameAs")
    public List<String> getSameReferenceLinks() {
        return this.sameAs;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Object getFieldValue(Field field) throws IllegalArgumentException, IllegalAccessException {
        return field.get(this);
    }

    @Override
    public void setFieldValue(Field field, Object value) throws IllegalArgumentException, IllegalAccessException {
        field.set(this, value);
    }
}

