/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import eu.europeana.entitymanagement.definitions.model.Address;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"@context", "id", "type", "depiction", "prefLabel", "acronym", "altLabel", "hiddenLabel", "description", "logo", "europeanaRole", "organizationDomain", "geographicLevel", "country", "language", "homepage", "phone", "mbox", "hasAddress", "identifier", "sameAs"})
public class Organization
extends Entity {
    private String type = EntityTypes.Organization.getEntityType();
    private Map<String, String> description;
    private Map<String, List<String>> acronym;
    private WebResource logo;
    private String homepage;
    private List<String> phone;
    private List<String> mbox;
    private Map<String, List<String>> europeanaRole;
    private Map<String, List<String>> organizationDomain;
    private Map<String, String> geographicLevel;
    private String country;
    private Address hasAddress;
    private List<String> sameAs;
    private List<String> language;

    public Organization() {
    }

    public Organization(Organization copy) {
        super(copy);
        if (copy.getDescription() != null) {
            this.description = new HashMap<String, String>(copy.getDescription());
        }
        if (copy.getAcronym() != null) {
            this.acronym = new HashMap<String, List<String>>(copy.getAcronym());
        }
        this.logo = copy.getLogo();
        this.homepage = copy.getHomepage();
        if (copy.getPhone() != null) {
            this.phone = new ArrayList<String>(copy.getPhone());
        }
        if (copy.getMbox() != null) {
            this.mbox = new ArrayList<String>(copy.getMbox());
        }
        if (copy.getEuropeanaRole() != null) {
            this.europeanaRole = new HashMap<String, List<String>>(copy.getEuropeanaRole());
        }
        if (copy.getOrganizationDomain() != null) {
            this.organizationDomain = new HashMap<String, List<String>>(copy.getOrganizationDomain());
        }
        if (copy.getGeographicLevel() != null) {
            this.geographicLevel = new HashMap<String, String>(copy.getGeographicLevel());
        }
        this.country = copy.getCountry();
        if (copy.getAddress() != null) {
            this.hasAddress = new Address(copy.getAddress());
        }
        if (copy.sameAs != null) {
            this.sameAs = new ArrayList<String>(copy.sameAs);
        }
        if (copy.language != null) {
            this.language = new ArrayList<String>(copy.language);
        }
    }

    @JsonGetter(value="description")
    public Map<String, String> getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(Map<String, String> dcDescription) {
        this.description = dcDescription;
    }

    @JsonGetter(value="acronym")
    public Map<String, List<String>> getAcronym() {
        return this.acronym;
    }

    @JsonSetter(value="acronym")
    public void setAcronym(Map<String, List<String>> acronym) {
        this.acronym = acronym;
    }

    @JsonGetter(value="europeanaRole")
    public Map<String, List<String>> getEuropeanaRole() {
        return this.europeanaRole;
    }

    @JsonSetter(value="europeanaRole")
    public void setEuropeanaRole(Map<String, List<String>> europeanaRole) {
        this.europeanaRole = europeanaRole;
    }

    @JsonGetter(value="phone")
    public List<String> getPhone() {
        return this.phone;
    }

    @JsonSetter(value="phone")
    public void setPhone(List<String> phone) {
        this.phone = phone;
    }

    @JsonGetter(value="mbox")
    public List<String> getMbox() {
        return this.mbox;
    }

    @JsonSetter(value="mbox")
    public void setMbox(List<String> mbox) {
        this.mbox = mbox;
    }

    @JsonGetter(value="country")
    public String getCountry() {
        return this.country;
    }

    @JsonSetter(value="country")
    public void setCountry(String country) {
        this.country = country;
    }

    @JsonGetter(value="hasAddress")
    public Address getAddress() {
        return this.hasAddress;
    }

    @JsonSetter(value="hasAddress")
    public void setAddress(Address hasAddress) {
        this.hasAddress = hasAddress;
    }

    @JsonGetter(value="geographicLevel")
    public Map<String, String> getGeographicLevel() {
        return this.geographicLevel;
    }

    @JsonSetter(value="geographicLevel")
    public void setGeographicLevel(Map<String, String> geographicLevel) {
        this.geographicLevel = geographicLevel;
    }

    @JsonGetter(value="organizationDomain")
    public Map<String, List<String>> getOrganizationDomain() {
        return this.organizationDomain;
    }

    @JsonSetter(value="organizationDomain")
    public void setOrganizationDomain(Map<String, List<String>> organizationDomain) {
        this.organizationDomain = organizationDomain;
    }

    @JsonGetter(value="homepage")
    public String getHomepage() {
        return this.homepage;
    }

    @JsonSetter(value="homepage")
    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    @JsonGetter(value="logo")
    public WebResource getLogo() {
        return this.logo;
    }

    @JsonSetter(value="logo")
    public void setLogo(WebResource logo) {
        this.logo = logo;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Object getFieldValue(Field field) throws IllegalArgumentException, IllegalAccessException {
        return field.get(this);
    }

    @Override
    @JsonSetter(value="sameAs")
    public void setSameReferenceLinks(List<String> uris) {
        this.sameAs = uris;
    }

    @Override
    @JsonGetter(value="sameAs")
    public List<String> getSameReferenceLinks() {
        return this.sameAs;
    }

    @Override
    public void setFieldValue(Field field, Object value) throws IllegalArgumentException, IllegalAccessException {
        field.set(this, value);
    }

    @JsonGetter(value="language")
    public List<String> getLanguage() {
        return this.language;
    }

    @JsonSetter(value="language")
    public void setLanguage(List<String> edmLanguage) {
        this.language = edmLanguage;
    }
}

