/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.batch.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Indexed;
import eu.europeana.entitymanagement.definitions.batch.model.ScheduledTaskType;
import java.time.Instant;
import org.bson.types.ObjectId;

@Entity(value="FailedTasks")
@JsonPropertyOrder(value={"type", "message", "occurences", "firstTime", "lastTime", "stacktrace"})
public class FailedTask {
    @JsonIgnore
    @Id
    private ObjectId dbId;
    @JsonIgnore
    @Indexed
    private String entityId;
    private String errorMessage;
    private String stackTrace;
    private ScheduledTaskType updateType;
    private int failureCount = 1;
    private Instant created;
    private Instant modified;

    private FailedTask() {
    }

    public FailedTask(String entityId, Instant modified, String errorMessage, String stackTrace, ScheduledTaskType updateType) {
        this.entityId = entityId;
        this.modified = modified;
        this.errorMessage = errorMessage;
        this.stackTrace = stackTrace;
        this.updateType = updateType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    @JsonGetter(value="firstTime")
    public Instant getCreated() {
        return this.created;
    }

    @JsonGetter(value="message")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonGetter(value="stacktrace")
    public String getStackTrace() {
        return this.stackTrace;
    }

    @JsonGetter(value="lastTime")
    public Instant getModified() {
        return this.modified;
    }

    @JsonGetter(value="occurences")
    public int getFailureCount() {
        return this.failureCount;
    }

    @JsonGetter(value="type")
    public ScheduledTaskType getUpdateType() {
        return this.updateType;
    }

    public String toString() {
        return "FailedTask{dbId=" + this.dbId + ", entityId='" + this.entityId + "', created=" + this.created + ", modified=" + this.modified + ", errorMessage='" + this.errorMessage + "', stackTrace='" + this.stackTrace + "'}";
    }

    public static class Builder {
        private final String entityId;
        private final ScheduledTaskType updateType;
        private Instant modified;
        private String errorMessage = "No error message";
        private String stackTrace = "No stacktrace";

        public Builder(String entityId, ScheduledTaskType updateType) {
            this.entityId = entityId;
            this.updateType = updateType;
        }

        public Builder modified(Instant modified) {
            this.modified = modified;
            return this;
        }

        public Builder message(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public FailedTask build() {
            return new FailedTask(this.entityId, this.modified, this.errorMessage, this.stackTrace, this.updateType);
        }
    }
}

