/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.vocabulary;

import eu.europeana.entitymanagement.definitions.exceptions.EntityFieldAccessException;

public enum EntityFieldsTypes {
    id("URI", false, "1..1"),
    entityId("URI", false, "1..1"),
    type("Keyword", false, "1..1"),
    depiction("WebResource", false, "0..1"),
    isShownBy("WebResource", false, "0..1"),
    prefLabel("Text", true, "1..1", 1),
    altLabel("Text", true, "0..*"),
    definition("Text", true, "0..1"),
    hiddenLabel("Keyword", false, "0..*"),
    sameAs("URI", false, "0..*"),
    language("Text", false, "0..*"),
    name("Text", true, "0..*"),
    begin("Date", false, "0..1"),
    end("Date", false, "0..1"),
    dateOfBirth("Date", false, "0..1"),
    dateOfEstablishment("Date", false, "0..1"),
    dateOfDeath("Date", false, "0..1"),
    dateOfTermination("Date", false, "0..1"),
    date("Date or URI", false, "0..*"),
    placeOfBirth("Text or URI", false, "0..*"),
    placeOfDeath("Text or URI", false, "0..*"),
    gender("Text", false, "0..1"),
    professionOrOccupation("Text or URI", false, "0..*"),
    biographicalInformation("Text", true, "0..*"),
    note("Text", true, "0..*"),
    hasPart("URI", false, "0..*"),
    isPartOf("URI", false, "0..*"),
    hasMet("URI", false, "0..*"),
    isRelatedTo("URI", false, "0..*"),
    wasPresentAt("URI", false, "0..*"),
    identifier("Keyword", false, "0..*"),
    latitude("Float", false, "0..1"),
    longitude("Float", false, "0..1"),
    altitude("Float", false, "0..1"),
    isNextInSequence("URI", false, "0..*"),
    notation("Text", false, "0..*"),
    broader("URI", false, "0..*"),
    narrower("URI", false, "0..*"),
    related("URI", false, "0..*"),
    broadMatch("URI", false, "0..*"),
    narrowMatch("URI", false, "0..*"),
    exactMatch("URI", false, "0..*"),
    relatedMatch("URI", false, "0..*"),
    closeMatch("URI", false, "0..*"),
    inScheme("URI", false, "0..*"),
    acronym("Text", true, "0..*"),
    description("Text", true, "0..1"),
    logo("WebResource", false, "0..1"),
    europeanaRole("Keyword", true, "0..*"),
    organizationDomain("Keyword", true, "0..*"),
    geographicLevel("Keyword", true, "0..1"),
    country("Text", false, "0..1"),
    homepage("URI", false, "0..1"),
    phone("Keyword", false, "0..*"),
    mbox("Email", false, "0..*"),
    hasAddress("Address", false, "0..1"),
    streetAddress("Text", false, "0..1"),
    postalCode("Keyword", false, "0..1"),
    postBox("Keyword", false, "0..1"),
    locality("Text", false, "0..1"),
    countryName("Text", false, "1..1"),
    hasGeo("URI", false, "0..1"),
    source("URI", false, "1..1"),
    thumbnail("URI", false, "1..1"),
    created("Date", false, "1..1"),
    modified("Date", false, "1..1"),
    pageRank("Integer", false, "1..1"),
    recordCount("Integer", false, "1..1"),
    score("Integer", false, "1..1"),
    aggregates("URI", false, "1..1"),
    proxyFor("URI", false, "1..1");

    public static final String FIELD_TYPE_URI = "URI";
    public static final String FIELD_TYPE_INTEGER = "Integer";
    public static final String FIELD_TYPE_DATE = "Date";
    public static final String FIELD_TYPE_TEXT = "Text";
    public static final String FIELD_TYPE_KEYWORD = "Keyword";
    public static final String FIELD_TYPE_EMAIL = "Email";
    public static final String FIELD_TYPE_FLOAT = "Float";
    public static final String FIELD_TYPE_TEXT_OR_URI = "Text or URI";
    public static final String FIELD_TYPE_DATE_OR_URI = "Date or URI";
    public static final String FIELD_TYPE_WEB_RESOURCE = "WebResource";
    public static final String FIELD_TYPE_ADDRESS = "Address";
    public static final String FIELD_CARDINALITY_1_1 = "1..1";
    public static final String FIELD_CARDINALITY_0_1 = "0..1";
    public static final String FIELD_CARDINALITY_0_INFINITE = "0..*";
    public static final String FIELD_CARDINALITY_1_INFINITE = "1..*";
    public static final String UNKNOWN_FIELD_STRING = "Unknown field: ";
    private final String fieldType;
    private final boolean fieldIsmultilingual;
    private final String fieldCardinality;
    private final int minContentCount;

    private EntityFieldsTypes(String fieldType, boolean fieldIsmultilingual, String fieldCardinality) {
        this(fieldType, fieldIsmultilingual, fieldCardinality, 0);
    }

    private EntityFieldsTypes(String fieldType, boolean fieldIsmultilingual, String fieldCardinality, int minContentCount) {
        this.fieldType = fieldType;
        this.fieldIsmultilingual = fieldIsmultilingual;
        this.fieldCardinality = fieldCardinality;
        this.minContentCount = minContentCount;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public static boolean hasTypeDefinition(String fieldName) {
        try {
            EntityFieldsTypes.valueOf(fieldName);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String getFieldType(String fieldName) {
        try {
            return EntityFieldsTypes.valueOf(fieldName).getFieldType();
        }
        catch (IllegalArgumentException e) {
            throw new EntityFieldAccessException(UNKNOWN_FIELD_STRING + fieldName, e);
        }
    }

    public static boolean isMultilingual(String fieldName) {
        return EntityFieldsTypes.hasTypeDefinition(fieldName) && EntityFieldsTypes.valueOf(fieldName).getFieldIsmultilingual();
    }

    public static boolean isListOrMap(String fieldName) {
        try {
            String cardinality = EntityFieldsTypes.valueOf(fieldName).getFieldCardinality();
            return FIELD_CARDINALITY_0_INFINITE.equals(cardinality) || FIELD_CARDINALITY_1_INFINITE.equals(cardinality);
        }
        catch (IllegalArgumentException e) {
            throw new EntityFieldAccessException(UNKNOWN_FIELD_STRING + fieldName, e);
        }
    }

    public static boolean isMandatory(String fieldName) {
        try {
            String cardinality = EntityFieldsTypes.valueOf(fieldName).getFieldCardinality();
            return FIELD_CARDINALITY_1_INFINITE.equals(cardinality) || FIELD_CARDINALITY_1_1.equals(cardinality);
        }
        catch (IllegalArgumentException e) {
            throw new EntityFieldAccessException(UNKNOWN_FIELD_STRING + fieldName, e);
        }
    }

    public static boolean isSingleValueField(String fieldName) {
        try {
            String cardinality = EntityFieldsTypes.valueOf(fieldName).getFieldCardinality();
            return FIELD_CARDINALITY_0_1.equals(cardinality) || FIELD_CARDINALITY_1_1.equals(cardinality);
        }
        catch (IllegalArgumentException e) {
            throw new EntityFieldAccessException(UNKNOWN_FIELD_STRING + fieldName, e);
        }
    }

    boolean getFieldIsmultilingual() {
        return this.fieldIsmultilingual;
    }

    public String getFieldCardinality() {
        return this.fieldCardinality;
    }

    public static int getMinContentCount(String fieldName) {
        return EntityFieldsTypes.valueOf((String)fieldName).minContentCount;
    }

    public static String getFieldCardinality(String fieldName) {
        try {
            return EntityFieldsTypes.valueOf(fieldName).getFieldCardinality();
        }
        catch (IllegalArgumentException e) {
            throw new EntityFieldAccessException(UNKNOWN_FIELD_STRING + fieldName, e);
        }
    }
}

