/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.utils;

import eu.europeana.api.commons.definitions.utils.ComparatorUtils;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class EMCollectionUtils {
    private EMCollectionUtils() {
    }

    public static <E> void addToList(@NotNull List<E> dest, @NotNull List<E> addition, int maxSize) {
        if (dest.size() < maxSize) {
            dest.addAll(addition.subList(0, Math.min(maxSize - dest.size(), addition.size())));
        }
    }

    public static String getFirstElement(List<String> values) {
        if (values != null && !values.isEmpty()) {
            Optional value = values.stream().findFirst();
            return value.isPresent() ? (String)value.get() : null;
        }
        return null;
    }

    public static boolean ifValueAlreadyExistsInList(List<Object> listPrimaryObject, Object elemSecondaryList, boolean doSloppyMatch) {
        if (listPrimaryObject.contains(elemSecondaryList)) {
            return true;
        }
        if (doSloppyMatch) {
            for (Object primaryValue : listPrimaryObject) {
                if (!ComparatorUtils.sameValueWithoutSpace((String)ComparatorUtils.stripPunctuation((String)primaryValue.toString()), (String)ComparatorUtils.stripPunctuation((String)elemSecondaryList.toString()))) continue;
                return true;
            }
        }
        return false;
    }
}

