/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.vocabulary;

import eu.europeana.entitymanagement.definitions.exceptions.UnsupportedEntityTypeException;
import eu.europeana.entitymanagement.vocabulary.EntityKeyword;

public enum EntityTypes implements EntityKeyword
{
    Organization("Organization", "http://www.europeana.eu/schemas/edm/Organization"),
    Concept("Concept", "https://www.w3.org/2009/08/skos-reference/skos.html#Concept"),
    Agent("Agent", "http://www.europeana.eu/schemas/edm/Agent"),
    Place("Place", "http://www.europeana.eu/schemas/edm/Place"),
    TimeSpan("TimeSpan", "http://www.europeana.eu/schemas/edm/TimeSpan");

    private String entityType;
    private String httpUri;

    public String getEntityType() {
        return this.entityType;
    }

    private EntityTypes(String entityType, String uri) {
        this.entityType = entityType;
        this.httpUri = uri;
    }

    @Deprecated
    public static boolean contains(String entityType) {
        for (EntityTypes field : EntityTypes.values()) {
            if (!field.getEntityType().equalsIgnoreCase(entityType)) continue;
            return true;
        }
        return false;
    }

    public static boolean arrayHasValue(EntityTypes[] entityTypes, EntityTypes entityType) {
        for (EntityTypes entType : entityTypes) {
            if (!entType.equals(entityType)) continue;
            return true;
        }
        return false;
    }

    public static EntityTypes getByEntityType(String entityType) throws UnsupportedEntityTypeException {
        for (EntityTypes entityTypeEnum : EntityTypes.values()) {
            if (!entityTypeEnum.getEntityType().equalsIgnoreCase(entityType)) continue;
            return entityTypeEnum;
        }
        throw new UnsupportedEntityTypeException(entityType);
    }

    public static EntityTypes getByEntityId(String entityId) throws UnsupportedEntityTypeException {
        for (EntityTypes field : EntityTypes.values()) {
            if (!entityId.contains(String.format("/%s/", field.getEntityType().toLowerCase()))) continue;
            return field;
        }
        throw new UnsupportedEntityTypeException(entityId);
    }

    public String getHttpUri() {
        return this.httpUri;
    }

    @Override
    public String getJsonValue() {
        return this.getEntityType();
    }
}

