/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.entitymanagement.definitions.exceptions.EntityCreationException;
import eu.europeana.entitymanagement.definitions.model.Place;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import eu.europeana.entitymanagement.web.xml.model.RdfXmlUtils;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.europeana.eu/schemas/edm/", name="Place")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"about", "depiction", "isShownBy", "prefLabel", "altLabel", "hiddenLabel", "latitude", "longitude", "altitude", "note", "hasPart", "isPartOf", "isNextInSequence", "sameAs", "isAggregatedBy"})
public class XmlPlaceImpl
extends XmlBaseEntityImpl<Place> {
    @XmlElement(namespace="http://www.w3.org/2002/07/owl#", name="sameAs")
    private List<LabelledResource> sameAs;
    @XmlElement(namespace="http://www.w3.org/2003/01/geo/wgs84_pos#", name="lat")
    private Float latitude;
    @XmlElement(namespace="http://www.w3.org/2003/01/geo/wgs84_pos#", name="long")
    private Float longitude;
    @XmlElement(namespace="http://www.w3.org/2003/01/geo/wgs84_pos#", name="alt")
    private Float altitude;
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="note")
    private List<LabelledResource> note;
    @XmlElement(namespace="http://purl.org/dc/terms/", name="hasPart")
    private List<LabelledResource> hasPart;
    @XmlElement(namespace="http://purl.org/dc/terms/", name="isPartOf")
    private List<LabelledResource> isPartOf;
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="isNextInSequence")
    private List<LabelledResource> isNextInSequence;

    public XmlPlaceImpl(Place place) {
        super(place);
        this.sameAs = RdfXmlUtils.convertToRdfResource(place.getSameReferenceLinks());
        this.latitude = place.getLatitude();
        this.longitude = place.getLongitude();
        this.altitude = place.getAltitude();
        this.note = RdfXmlUtils.convertToXmlMultilingualString(place.getNote());
        this.hasPart = RdfXmlUtils.convertToRdfResource(place.getHasPart());
        this.isPartOf = RdfXmlUtils.convertToRdfResource(place.getIsPartOfArray());
        this.isNextInSequence = RdfXmlUtils.convertToRdfResource(place.getIsNextInSequence());
    }

    public XmlPlaceImpl() {
    }

    @Override
    public Place toEntityModel() throws EntityCreationException {
        super.toEntityModel();
        ((Place)this.entity).setLatitude(this.getLatitude());
        ((Place)this.entity).setLongitude(this.getLongitude());
        ((Place)this.entity).setAltitude(this.getAltitude());
        ((Place)this.entity).setNote(RdfXmlUtils.toLanguageMapList(this.getNote()));
        ((Place)this.entity).setHasPart(RdfXmlUtils.toStringList(this.getHasPart()));
        ((Place)this.entity).setIsPartOfArray(RdfXmlUtils.toStringList(this.getIsPartOf()));
        ((Place)this.entity).setIsNextInSequence(RdfXmlUtils.toStringList(this.getIsNextInSequence()));
        return (Place)this.entity;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public Float getAltitude() {
        return this.altitude;
    }

    public List<LabelledResource> getNote() {
        return this.note;
    }

    public List<LabelledResource> getHasPart() {
        return this.hasPart;
    }

    public List<LabelledResource> getIsPartOf() {
        return this.isPartOf;
    }

    public List<LabelledResource> getIsNextInSequence() {
        return this.isNextInSequence;
    }

    @Override
    protected EntityTypes getTypeEnum() {
        return EntityTypes.Place;
    }

    @Override
    public List<LabelledResource> getSameReferenceLinks() {
        return this.sameAs;
    }

    @Override
    public void setSameReferenceLinks(List<LabelledResource> uris) {
        this.sameAs = uris;
    }
}

