/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.entitymanagement.definitions.exceptions.EntityCreationException;
import eu.europeana.entitymanagement.definitions.model.Agent;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import eu.europeana.entitymanagement.web.xml.model.RdfXmlUtils;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.europeana.eu/schemas/edm/", name="Agent")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"about", "depiction", "isShownBy", "prefLabel", "altLabel", "hiddenLabel", "name", "begin", "dateOfBirth", "dateOfEstablishment", "end", "dateOfDeath", "dateOfTermination", "date", "placeOfBirth", "placeOfDeath", "gender", "professionOrOccupation", "biographicalInformation", "note", "hasPart", "isPartOf", "hasMet", "isRelatedTo", "wasPresentAt", "identifier", "sameAs", "isAggregatedBy"})
public class XmlAgentImpl
extends XmlBaseEntityImpl<Agent> {
    @XmlElement(namespace="http://www.w3.org/2002/07/owl#", name="sameAs")
    private List<LabelledResource> sameAs = new ArrayList<LabelledResource>();
    @XmlElement(name="isPartOf", namespace="http://purl.org/dc/terms/")
    private List<LabelledResource> isPartOf = new ArrayList<LabelledResource>();
    @XmlElement(name="identifier", namespace="http://purl.org/dc/elements/1.1/")
    private List<String> identifier;
    @XmlElement(name="note", namespace="http://www.w3.org/2004/02/skos/core#")
    private List<LabelledResource> note = new ArrayList<LabelledResource>();
    @XmlElement(name="hasPart", namespace="http://purl.org/dc/terms/")
    private List<LabelledResource> hasPart = new ArrayList<LabelledResource>();
    @XmlElement(name="hasMet", namespace="http://www.europeana.eu/schemas/edm/")
    private List<LabelledResource> hasMet = new ArrayList<LabelledResource>();
    @XmlElement(name="wasPresentAt", namespace="http://www.europeana.eu/schemas/edm/")
    private List<LabelledResource> wasPresentAt = new ArrayList<LabelledResource>();
    @XmlElement(name="biographicalInformation", namespace="http://rdvocab.info/ElementsGr2/")
    private List<LabelledResource> biographicalInformation = new ArrayList<LabelledResource>();
    @XmlElement(name="begin", namespace="http://www.europeana.eu/schemas/edm/")
    private List<String> begin;
    @XmlElement(name="end", namespace="http://www.europeana.eu/schemas/edm/")
    private List<String> end;
    @XmlElement(name="isRelatedTo", namespace="http://www.europeana.eu/schemas/edm/")
    private List<LabelledResource> isRelatedTo = new ArrayList<LabelledResource>();
    @XmlElement(name="name", namespace="http://xmlns.com/foaf/0.1/")
    private List<LabelledResource> name = new ArrayList<LabelledResource>();
    @XmlElement(name="dateOfBirth", namespace="http://rdvocab.info/ElementsGr2/")
    private List<String> dateOfBirth;
    @XmlElement(name="dateOfDeath", namespace="http://rdvocab.info/ElementsGr2/")
    private List<String> dateOfDeath;
    @XmlElement(name="dateOfEstablishment", namespace="http://rdvocab.info/ElementsGr2/")
    private List<String> dateOfEstablishment;
    @XmlElement(name="dateOfTermination", namespace="http://rdvocab.info/ElementsGr2/")
    private List<String> dateOfTermination;
    @XmlElement(name="date", namespace="http://purl.org/dc/elements/1.1/")
    private List<String> date;
    @XmlElement(name="gender", namespace="http://rdvocab.info/ElementsGr2/")
    private List<String> gender;
    @XmlElement(name="placeOfBirth", namespace="http://rdvocab.info/ElementsGr2/")
    private List<LabelledResource> placeOfBirth = new ArrayList<LabelledResource>();
    @XmlElement(name="placeOfDeath", namespace="http://rdvocab.info/ElementsGr2/")
    private List<LabelledResource> placeOfDeath = new ArrayList<LabelledResource>();
    @XmlElement(name="professionOrOccupation", namespace="http://rdvocab.info/ElementsGr2/")
    private List<LabelledResource> professionOrOccupation = new ArrayList<LabelledResource>();

    public XmlAgentImpl(Agent agent) {
        super(agent);
        this.sameAs = RdfXmlUtils.convertToRdfResource(agent.getSameReferenceLinks());
        this.note = RdfXmlUtils.convertToXmlMultilingualString(agent.getNote());
        if (agent.getIdentifier() != null) {
            this.identifier = agent.getIdentifier();
        }
        this.hasPart = RdfXmlUtils.convertToRdfResource(agent.getHasPart());
        this.isPartOf = RdfXmlUtils.convertToRdfResource(agent.getIsPartOfArray());
        if (agent.getBegin() != null) {
            this.begin = agent.getBegin();
        }
        if (agent.getEnd() != null) {
            this.end = agent.getEnd();
        }
        this.hasMet = RdfXmlUtils.convertToRdfResource(agent.getHasMet());
        this.isRelatedTo = RdfXmlUtils.convertToRdfResource(agent.getIsRelatedTo());
        this.wasPresentAt = RdfXmlUtils.convertToRdfResource(agent.getWasPresentAt());
        this.name = RdfXmlUtils.convertMapToXmlMultilingualString(agent.getName());
        this.biographicalInformation = RdfXmlUtils.convertToXmlMultilingualString(agent.getBiographicalInformation());
        if (agent.getDateOfBirth() != null) {
            this.dateOfBirth = agent.getDateOfBirth();
        }
        if (agent.getDateOfDeath() != null) {
            this.dateOfDeath = agent.getDateOfDeath();
        }
        if (agent.getDateOfEstablishment() != null) {
            this.dateOfEstablishment = agent.getDateOfEstablishment();
        }
        if (agent.getDateOfTermination() != null) {
            this.dateOfTermination = agent.getDateOfTermination();
        }
        if (agent.getDate() != null) {
            this.date = agent.getDate();
        }
        if (agent.getGender() != null) {
            this.gender = agent.getGender();
        }
        this.placeOfBirth = RdfXmlUtils.convertToRdfResource(agent.getPlaceOfBirth());
        this.placeOfDeath = RdfXmlUtils.convertToRdfResource(agent.getPlaceOfDeath());
        this.professionOrOccupation = RdfXmlUtils.convertToRdfResource(agent.getProfessionOrOccupation());
    }

    public XmlAgentImpl() {
    }

    @Override
    public Agent toEntityModel() throws EntityCreationException {
        super.toEntityModel();
        ((Agent)this.entity).setNote(RdfXmlUtils.toLanguageMapList(this.note));
        ((Agent)this.entity).setIdentifier(this.identifier);
        ((Agent)this.entity).setHasPart(RdfXmlUtils.toStringList(this.hasPart));
        ((Agent)this.entity).setIsPartOfArray(RdfXmlUtils.toStringList(this.isPartOf));
        ((Agent)this.entity).setBegin(this.begin);
        ((Agent)this.entity).setEnd(this.end);
        ((Agent)this.entity).setHasMet(RdfXmlUtils.toStringList(this.hasMet));
        ((Agent)this.entity).setIsRelatedTo(RdfXmlUtils.toStringList(this.isRelatedTo));
        ((Agent)this.entity).setWasPresentAt(RdfXmlUtils.toStringList(this.wasPresentAt));
        ((Agent)this.entity).setName(RdfXmlUtils.toLanguageMap(this.name));
        ((Agent)this.entity).setBiographicalInformation(RdfXmlUtils.toLanguageMapList(this.biographicalInformation));
        ((Agent)this.entity).setDateOfBirth(this.dateOfBirth);
        ((Agent)this.entity).setDateOfDeath(this.dateOfDeath);
        ((Agent)this.entity).setDateOfEstablishment(this.dateOfEstablishment);
        ((Agent)this.entity).setDateOfTermination(this.dateOfTermination);
        ((Agent)this.entity).setDate(this.date);
        ((Agent)this.entity).setGender(this.gender);
        ((Agent)this.entity).setPlaceOfBirth(RdfXmlUtils.toStringList(this.placeOfBirth));
        ((Agent)this.entity).setPlaceOfDeath(RdfXmlUtils.toStringList(this.placeOfDeath));
        ((Agent)this.entity).setProfessionOrOccupation(RdfXmlUtils.toStringList(this.professionOrOccupation));
        return (Agent)this.entity;
    }

    public List<LabelledResource> getNote() {
        return this.note;
    }

    public List<String> getDate() {
        return this.date;
    }

    public List<String> getIdentifier() {
        return this.identifier;
    }

    public List<LabelledResource> getHasPart() {
        return this.hasPart;
    }

    public List<LabelledResource> getIsPartOf() {
        return this.isPartOf;
    }

    public List<String> getBegin() {
        return this.begin;
    }

    public List<String> getEnd() {
        return this.end;
    }

    public List<LabelledResource> getHasMet() {
        return this.hasMet;
    }

    public List<LabelledResource> getIsRelatedTo() {
        return this.isRelatedTo;
    }

    public List<LabelledResource> getWasPresentAt() {
        return this.wasPresentAt;
    }

    public List<LabelledResource> getName() {
        return this.name;
    }

    public List<LabelledResource> getBiographicalInformation() {
        return this.biographicalInformation;
    }

    public List<String> getDateOfBirth() {
        return this.dateOfBirth;
    }

    public List<String> getDateOfDeath() {
        return this.dateOfDeath;
    }

    public List<String> getDateOfEstablishment() {
        return this.dateOfEstablishment;
    }

    public List<String> getDateOfTermination() {
        return this.dateOfTermination;
    }

    public List<String> getGender() {
        return this.gender;
    }

    public List<LabelledResource> getPlaceOfBirth() {
        return this.placeOfBirth;
    }

    public List<LabelledResource> getPlaceOfDeath() {
        return this.placeOfDeath;
    }

    public List<LabelledResource> getProfessionOrOccupation() {
        return this.professionOrOccupation;
    }

    @Override
    protected EntityTypes getTypeEnum() {
        return EntityTypes.Agent;
    }

    @Override
    public List<LabelledResource> getSameReferenceLinks() {
        return this.sameAs;
    }

    @Override
    public void setSameReferenceLinks(List<LabelledResource> uris) {
        this.sameAs = uris;
    }
}

