/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.entitymanagement.definitions.model.WebResource;
import eu.europeana.entitymanagement.utils.EntityUtils;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import eu.europeana.entitymanagement.web.xml.model.XmlWebResourceImpl;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.springframework.util.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class XmlWebResourceWrapper {
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="WebResource")
    private XmlWebResourceImpl webResource;

    public XmlWebResourceWrapper(XmlWebResourceImpl webResource) {
        this.webResource = webResource;
    }

    public XmlWebResourceWrapper() {
    }

    public XmlWebResourceImpl getWebResource() {
        return this.webResource;
    }

    public void setWebResource(XmlWebResourceImpl webResource) {
        this.webResource = webResource;
    }

    public static XmlWebResourceWrapper fromWebResource(WebResource webResource) {
        if (webResource == null) {
            return null;
        }
        return new XmlWebResourceWrapper(new XmlWebResourceImpl(webResource.getId(), webResource.getSource(), webResource.getThumbnail()));
    }

    public static WebResource toWebResource(XmlWebResourceWrapper xmlWebResourceWrapper) {
        if (xmlWebResourceWrapper == null || xmlWebResourceWrapper.getWebResource() == null || xmlWebResourceWrapper.getWebResource().getAbout() == null) {
            return null;
        }
        WebResource webResource = new WebResource();
        webResource.setId(xmlWebResourceWrapper.getWebResource().getAbout());
        LabelledResource source = xmlWebResourceWrapper.getWebResource().getSource();
        if (source != null && StringUtils.hasLength((String)source.getResource())) {
            webResource.setSource(source.getResource());
        } else {
            webResource.setSource(EntityUtils.createWikimediaResourceString(webResource.getId()));
        }
        LabelledResource thumbnail = xmlWebResourceWrapper.getWebResource().getThumbnail();
        if (thumbnail != null) {
            webResource.setThumbnail(thumbnail.getResource());
        }
        return webResource;
    }
}

