/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.entitymanagement.definitions.exceptions.EntityCreationException;
import eu.europeana.entitymanagement.definitions.model.TimeSpan;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import eu.europeana.entitymanagement.web.xml.model.RdfXmlUtils;
import eu.europeana.entitymanagement.web.xml.model.XmlBaseEntityImpl;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.europeana.eu/schemas/edm/", name="TimeSpan")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"about", "depiction", "isShownBy", "prefLabel", "altLabel", "hiddenLabel", "begin", "end", "note", "hasPart", "isPartOf", "isNextInSequence", "sameAs", "isAggregatedBy"})
public class XmlTimeSpanImpl
extends XmlBaseEntityImpl<TimeSpan> {
    @XmlElement(namespace="http://www.w3.org/2002/07/owl#", name="sameAs")
    private List<LabelledResource> sameAs;
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="begin")
    private String begin;
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="end")
    private String end;
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="note")
    private List<LabelledResource> note;
    @XmlElement(namespace="http://purl.org/dc/terms/", name="hasPart")
    private List<LabelledResource> hasPart;
    @XmlElement(namespace="http://purl.org/dc/terms/", name="isPartOf")
    private List<LabelledResource> isPartOf;
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="isNextInSequence")
    private List<LabelledResource> isNextInSequence;

    public XmlTimeSpanImpl(TimeSpan timespan) {
        super(timespan);
        this.sameAs = RdfXmlUtils.convertToRdfResource(timespan.getSameReferenceLinks());
        this.begin = timespan.getBeginString();
        this.end = timespan.getEndString();
        this.note = RdfXmlUtils.convertToXmlMultilingualString(timespan.getNote());
        this.hasPart = RdfXmlUtils.convertToRdfResource(timespan.getHasPart());
        this.isPartOf = RdfXmlUtils.convertToRdfResource(timespan.getIsPartOfArray());
        this.isNextInSequence = RdfXmlUtils.convertToRdfResource(timespan.getIsNextInSequence());
    }

    public XmlTimeSpanImpl() {
    }

    @Override
    public TimeSpan toEntityModel() throws EntityCreationException {
        super.toEntityModel();
        ((TimeSpan)this.entity).setBeginString(this.begin);
        ((TimeSpan)this.entity).setEndString(this.end);
        ((TimeSpan)this.entity).setNote(RdfXmlUtils.toLanguageMapList(this.note));
        ((TimeSpan)this.entity).setHasPart(RdfXmlUtils.toStringList(this.hasPart));
        ((TimeSpan)this.entity).setIsPartOfArray(RdfXmlUtils.toStringList(this.isPartOf));
        ((TimeSpan)this.entity).setIsNextInSequence(RdfXmlUtils.toStringList(this.isNextInSequence));
        return (TimeSpan)this.entity;
    }

    public String getBegin() {
        return this.begin;
    }

    public String getEnd() {
        return this.end;
    }

    public List<LabelledResource> getNote() {
        return this.note;
    }

    public List<LabelledResource> getHasPart() {
        return this.hasPart;
    }

    public List<LabelledResource> getIsPartOf() {
        return this.isPartOf;
    }

    public List<LabelledResource> getIsNextInSequence() {
        return this.isNextInSequence;
    }

    @Override
    protected EntityTypes getTypeEnum() {
        return EntityTypes.TimeSpan;
    }

    @Override
    public List<LabelledResource> getSameReferenceLinks() {
        return this.sameAs;
    }

    @Override
    public void setSameReferenceLinks(List<LabelledResource> uris) {
        this.sameAs = uris;
    }
}

