/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.corelib.utils.EuropeanaUriUtils;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public class RdfXmlUtils {
    public static List<LabelledResource> convertToRdfResource(List<String> elements) {
        if (elements == null) {
            return null;
        }
        return elements.stream().map(LabelledResource::new).collect(Collectors.toList());
    }

    public static List<LabelledResource> convertToXmlMultilingualString(Map<String, List<String>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<LabelledResource> res = new ArrayList<LabelledResource>();
        for (String language : values.keySet()) {
            List<String> entryValues = values.get(language);
            for (String entryValue : entryValues) {
                res.add(new LabelledResource(language, StringEscapeUtils.escapeXml11((String)entryValue)));
            }
        }
        return res;
    }

    public static List<LabelledResource> convertToXmlMultilingualStringOrRdfResource(Map<String, List<String>> values) {
        if (values == null) {
            return null;
        }
        ArrayList<LabelledResource> res = new ArrayList<LabelledResource>();
        for (String language : values.keySet()) {
            List<String> entryValues = values.get(language);
            for (String entryValue : entryValues) {
                if (EuropeanaUriUtils.isUri((String)entryValue)) {
                    res.add(new LabelledResource(entryValue));
                    continue;
                }
                res.add(new LabelledResource(language, StringEscapeUtils.escapeXml11((String)entryValue)));
            }
        }
        return res;
    }

    public static List<LabelledResource> convertMapToXmlMultilingualString(Map<String, String> values) {
        if (values == null) {
            return null;
        }
        ArrayList<LabelledResource> res = new ArrayList<LabelledResource>();
        for (String language : values.keySet()) {
            res.add(new LabelledResource(StringEscapeUtils.escapeXml11((String)values.get(language)), language));
        }
        return res;
    }

    public static Map<String, String> toLanguageMap(List<LabelledResource> multilingualStrings) {
        if (multilingualStrings == null) {
            return null;
        }
        HashMap<String, String> res = new HashMap<String, String>(multilingualStrings.size());
        for (LabelledResource xmlMultilingualString : multilingualStrings) {
            res.putIfAbsent(xmlMultilingualString.getLang(), xmlMultilingualString.getValue());
        }
        return res;
    }

    public static Map<String, List<String>> toLanguageMapList(List<LabelledResource> multilingualStrings) {
        if (multilingualStrings == null) {
            return null;
        }
        HashMap<String, List<String>> res = new HashMap<String, List<String>>(multilingualStrings.size());
        for (LabelledResource xmlMultilingualString : multilingualStrings) {
            if (res.containsKey(xmlMultilingualString.getLang())) {
                ((List)res.get(xmlMultilingualString.getLang())).add(xmlMultilingualString.getValue());
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(xmlMultilingualString.getValue());
            res.put(xmlMultilingualString.getLang(), values);
        }
        return res;
    }

    public static List<String> toStringList(List<LabelledResource> resources) {
        if (resources == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (LabelledResource labelledResource : resources) {
            if (labelledResource.getResource() != null) {
                res.add(labelledResource.getResource());
                continue;
            }
            res.add(labelledResource.getValue());
        }
        return res;
    }
}

