/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.web.xml.model;

import eu.europeana.entitymanagement.definitions.exceptions.EntityCreationException;
import eu.europeana.entitymanagement.definitions.model.Entity;
import eu.europeana.entitymanagement.utils.EntityObjectFactory;
import eu.europeana.entitymanagement.vocabulary.EntityTypes;
import eu.europeana.entitymanagement.web.xml.model.LabelledResource;
import eu.europeana.entitymanagement.web.xml.model.RdfXmlUtils;
import eu.europeana.entitymanagement.web.xml.model.XmlAggregationImpl;
import eu.europeana.entitymanagement.web.xml.model.XmlWebResourceWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlTransient
public abstract class XmlBaseEntityImpl<T extends Entity> {
    @XmlTransient
    protected T entity;
    @XmlAttribute(namespace="http://www.w3.org/1999/02/22-rdf-syntax-ns#", name="about")
    private String about;
    @XmlElement(namespace="http://www.europeana.eu/schemas/edm/", name="isShownBy")
    private XmlWebResourceWrapper isShownBy;
    @XmlElement(namespace="http://xmlns.com/foaf/0.1/", name="depiction")
    private XmlWebResourceWrapper depiction;
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="altLabel")
    private List<LabelledResource> altLabel = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="prefLabel")
    private List<LabelledResource> prefLabel = new ArrayList<LabelledResource>();
    @XmlElement(namespace="http://www.w3.org/2004/02/skos/core#", name="hiddenLabel")
    private List<String> hiddenLabel;
    @XmlElement(namespace="http://www.openarchives.org/ore/terms/", name="isAggregatedBy")
    private XmlAggregationImpl isAggregatedBy;

    protected XmlBaseEntityImpl() {
    }

    public XmlWebResourceWrapper getIsShownBy() {
        return this.isShownBy;
    }

    protected XmlBaseEntityImpl(T entity) {
        this.entity = entity;
        this.about = ((Entity)entity).getAbout();
        this.prefLabel = RdfXmlUtils.convertMapToXmlMultilingualString(((Entity)entity).getPrefLabel());
        this.altLabel = RdfXmlUtils.convertToXmlMultilingualString(((Entity)entity).getAltLabel());
        if (((Entity)entity).getHiddenLabel() != null) {
            this.hiddenLabel = new ArrayList<String>(((Entity)entity).getHiddenLabel());
        }
        if (((Entity)entity).getIsAggregatedBy() != null) {
            this.isAggregatedBy = new XmlAggregationImpl(((Entity)entity).getIsAggregatedBy());
        }
        this.isShownBy = XmlWebResourceWrapper.fromWebResource(((Entity)entity).getIsShownBy());
        this.depiction = XmlWebResourceWrapper.fromWebResource(((Entity)entity).getDepiction());
    }

    public T toEntityModel() throws EntityCreationException {
        if (this.entity == null) {
            this.entity = EntityObjectFactory.createProxyEntityObject(this.getTypeEnum().getEntityType());
        }
        ((Entity)this.entity).setEntityId(this.getAbout());
        ((Entity)this.entity).setPrefLabel(RdfXmlUtils.toLanguageMap(this.getPrefLabel()));
        ((Entity)this.entity).setAltLabel(RdfXmlUtils.toLanguageMapList(this.getAltLabel()));
        ((Entity)this.entity).setHiddenLabel(this.getHiddenLabel());
        ((Entity)this.entity).setSameReferenceLinks(RdfXmlUtils.toStringList(this.getSameReferenceLinks()));
        ((Entity)this.entity).setDepiction(XmlWebResourceWrapper.toWebResource(this.depiction));
        return this.entity;
    }

    protected abstract EntityTypes getTypeEnum();

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public XmlWebResourceWrapper getDepiction() {
        return this.depiction;
    }

    public List<LabelledResource> getPrefLabel() {
        return this.prefLabel;
    }

    public List<LabelledResource> getAltLabel() {
        return this.altLabel;
    }

    public List<String> getHiddenLabel() {
        return this.hiddenLabel;
    }

    public T getEntity() {
        return this.entity;
    }

    public abstract List<LabelledResource> getSameReferenceLinks();

    public abstract void setSameReferenceLinks(List<LabelledResource> var1);

    public boolean hasCoref(String uri) {
        if (uri == null || this.getSameReferenceLinks() == null || this.getSameReferenceLinks().isEmpty()) {
            return false;
        }
        return this.getSameReferenceLinks().stream().anyMatch(e -> uri.equals(e.getResource()));
    }
}

