/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.vocabulary;

import eu.europeana.entitymanagement.definitions.exceptions.UnsupportedFormatTypeException;

public enum FormatTypes {
    jsonld("jsonld"),
    schema("schema.jsonld"),
    xml("xml");

    private String extension;

    public String getExtention() {
        return this.extension;
    }

    private FormatTypes(String extention) {
        this.extension = extention;
    }

    public static FormatTypes getByExtention(String extention) throws UnsupportedFormatTypeException {
        for (FormatTypes formatType : FormatTypes.values()) {
            if (!formatType.getExtention().equalsIgnoreCase(extention)) continue;
            return formatType;
        }
        throw new UnsupportedFormatTypeException(extention);
    }

    public static FormatTypes getByName(String name) throws UnsupportedFormatTypeException {
        for (FormatTypes formatType : FormatTypes.values()) {
            if (!formatType.name().equalsIgnoreCase(name)) continue;
            return formatType;
        }
        throw new UnsupportedFormatTypeException(name);
    }

    public static boolean contains(String formatType) {
        for (FormatTypes field : FormatTypes.values()) {
            if (!field.getExtention().equalsIgnoreCase(formatType)) continue;
            return true;
        }
        return false;
    }
}

