/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.definitions.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import dev.morphia.annotations.Embedded;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Embedded
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"id", "type", "created", "modified", "pageRank", "recordCount", "score", "aggregates"})
public class Aggregation {
    private String id;
    private String type;
    private String rights;
    private String source;
    private Date created;
    private Date modified;
    private Integer score;
    private Integer recordCount;
    private Double pageRank;
    private List<String> aggregates;

    public Aggregation() {
    }

    public Aggregation(Aggregation copy) {
        this.id = copy.getId();
        this.type = copy.getAggregationType();
        this.rights = copy.getRights();
        this.source = copy.getSource();
        this.created = copy.getCreated();
        this.modified = copy.getModified();
        this.score = copy.getScore();
        this.recordCount = copy.getRecordCount();
        this.pageRank = copy.getPageRank();
        if (copy.getAggregates() != null) {
            this.aggregates = new ArrayList<String>(copy.getAggregates());
        }
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="type")
    public String getAggregationType() {
        return "Aggregation";
    }

    @JsonGetter(value="rights")
    public String getRights() {
        return this.rights;
    }

    @JsonSetter(value="rights")
    public void setRights(String rights) {
        this.rights = rights;
    }

    @JsonGetter(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonSetter(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    @JsonGetter(value="created")
    public Date getCreated() {
        return this.created;
    }

    @JsonSetter(value="created")
    public void setCreated(Date created) {
        this.created = created;
    }

    @JsonGetter(value="modified")
    public Date getModified() {
        return this.modified;
    }

    @JsonSetter(value="modified")
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @JsonGetter(value="pageRank")
    public Double getPageRank() {
        return this.pageRank;
    }

    @JsonSetter(value="pageRank")
    public void setPageRank(Double pageRank) {
        this.pageRank = pageRank;
    }

    @JsonGetter(value="recordCount")
    public Integer getRecordCount() {
        return this.recordCount;
    }

    @JsonSetter(value="recordCount")
    public void setRecordCount(Integer recordCount) {
        this.recordCount = recordCount;
    }

    @JsonGetter(value="score")
    public Integer getScore() {
        return this.score;
    }

    @JsonSetter(value="score")
    public void setScore(Integer score) {
        this.score = score;
    }

    @JsonGetter(value="aggregates")
    public List<String> getAggregates() {
        return this.aggregates;
    }

    @JsonSetter(value="aggregates")
    public void setAggregates(List<String> aggregates) {
        this.aggregates = aggregates;
    }
}

