/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.common.config;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JacksonXmlRootElement(localName="languages")
public class LanguageCodes {
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(localName="language")
    private List<Language> languages;
    Set<String> supportedLangCodes;
    private Map<String, String> altLangMap = new HashMap<String, String>();

    public List<Language> getLanguages() {
        return this.languages;
    }

    public Map<String, String> getAltLangMap() {
        if (this.altLangMap.isEmpty()) {
            for (Language language : this.getLanguages()) {
                for (Language altLang : language.getAlternativeLanguages()) {
                    this.altLangMap.put(altLang.getCode(), language.getCode());
                }
            }
        }
        return this.altLangMap;
    }

    public boolean isValidLanguageCode(String lang) {
        if (lang == null) {
            return false;
        }
        return this.getSupportedLangCodes().contains(lang.toLowerCase());
    }

    public boolean isValidAltLanguageCode(String altLangCode) {
        if (altLangCode == null) {
            return false;
        }
        return this.getAltLangMap().containsKey(altLangCode.toLowerCase());
    }

    public Set<String> getSupportedLangCodes() {
        if (this.supportedLangCodes == null) {
            this.supportedLangCodes = new HashSet<String>(this.languages.size());
            for (Language language : this.languages) {
                this.supportedLangCodes.add(language.getCode());
            }
        }
        return this.supportedLangCodes;
    }

    public String getByAlternativeCode(String altLang) {
        if (altLang == null || !this.getAltLangMap().containsKey(altLang.toLowerCase())) {
            return null;
        }
        return this.getAltLangMap().get(altLang.toLowerCase());
    }

    public static class Language {
        @JacksonXmlProperty(isAttribute=true, localName="code")
        private String code;
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="altLang")
        private List<Language> alternativeLanguages;

        public String getCode() {
            return this.code;
        }

        public List<Language> getAlternativeLanguages() {
            return this.alternativeLanguages;
        }

        public String toString() {
            return this.getCode();
        }
    }
}

