/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entitymanagement.common.config;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:entitymanagement.properties"}), @PropertySource(value={"classpath:entitymanagement.user.properties"}, ignoreResourceNotFound=true)})
public class EntityManagementConfiguration {
    private static final Logger LOG = LogManager.getLogger(EntityManagementConfiguration.class);
    @Value(value="${datasources.config}")
    private String datasourcesXMLConfig;
    @Value(value="${languagecodes.config}")
    private String languagecodesXMLConfig;
    @Value(value="${europeana.apikey.jwttoken.signaturekey}")
    private String apiKeyPublicKey;
    @Value(value="${europeana.thumbnail.urlPrefix}")
    private String thumbnailBaseUrl;
    @Value(value="${europeana.apikey.serviceurl}")
    private String apiKeyUrl;
    @Value(value="${entitymanagement.solr.pr.url}")
    private String prSolrUrl;
    @Value(value="${europeana.searchapi.urlPrefix}")
    private String searchApiUrlPrefix;
    @Value(value="${europeana.searchapi.enrichments.contentTier}")
    private String enrichmentsQueryContentTier;
    @Value(value="${entitymanagement.solr.indexing.url}")
    private String indexingSolrUrl;
    @Value(value="${entitymanagement.solr.indexing.explicitCommits: false}")
    private boolean explicitCommitsEnabled;
    @Value(value="${entitymanagement.solr.indexing.query.maxPageSize: 300}")
    private int solrQueryMaxPageSize;
    @Value(value="${entitymanagement.solr.searchapi.hits.query}")
    private String hitsQuery;
    @Value(value="${authorization.api.name}")
    private String authorizationApiName;
    @Value(value="${metis.baseUrl}")
    private String metisBaseUrl;
    @Value(value="${wikidata.baseUrl:}")
    private String wikidataBaseUrl;
    @Value(value="${batch.step.chunkSize: 10}")
    private int batchChunkSize;
    @Value(value="${batch.step.updates.executor.corePool: 10}")
    private int batchUpdatesCorePoolSize;
    @Value(value="${batch.step.updates.executor.maxPool: 100}")
    private int batchUpdatesMaxPoolSize;
    @Value(value="${batch.step.updates.executor.queueSize: 50}")
    private int batchUpdatesQueueSize;
    @Value(value="${batch.step.updates.throttleLimit: 10}")
    private int batchUpdatesThrottleLimit;
    @Value(value="${batch.step.removals.executor.corePool: 2}")
    private int batchRemovalsCorePoolSize;
    @Value(value="${batch.step.removals.executor.maxPool: 10}")
    private int batchRemovalsMaxPoolSize;
    @Value(value="${batch.step.removals.executor.queueSize: 5}")
    private int batchRemovalsQueueSize;
    @Value(value="${batch.step.removals.throttleLimit: 2}")
    private int batchRemovalsThrottleLimit;
    @Value(value="${batch.computeMetrics: false}")
    private boolean batchComputeMetrics;
    @Value(value="${batch.maxFailedTaskRetries: 3}")
    private int maxFailedTaskRetries;
    @Value(value="${auth.enabled: true}")
    private boolean authEnabled;
    @Value(value="${metis.proxy.enabled: false}")
    private boolean useMetisProxy;
    @Value(value="${metis.proxy.url:}")
    private String metisProxyUrl;
    @Value(value="${entitymanagement.entityIdResponseMaxSize: 100}")
    private int entityIdResponseMaxSize;
    @Value(value="${zoho.sync.filter.owner:DPS Team}")
    private String zohoSyncOwnerFilter;
    @Value(value="${zoho.sync.batch.size: 100}")
    private int zohoSyncBatchSize;

    public EntityManagementConfiguration() {
        LOG.info("Initializing EntityManagementConfiguration bean as: configuration");
    }

    public String getPrSolrUrl() {
        return this.prSolrUrl;
    }

    public String getSearchApiUrlPrefix() {
        return this.searchApiUrlPrefix;
    }

    public String getHitsQuery() {
        return this.hitsQuery;
    }

    public String getApiKeyPublicKey() {
        return this.apiKeyPublicKey;
    }

    public String getApiKeyUrl() {
        return this.apiKeyUrl;
    }

    public String getAuthorizationApiName() {
        return this.authorizationApiName;
    }

    public String getMetisBaseUrl() {
        return this.metisBaseUrl;
    }

    public String getDatasourcesXMLConfig() {
        return this.datasourcesXMLConfig;
    }

    public String getLanguagecodesXMLConfig() {
        return this.languagecodesXMLConfig;
    }

    public int getBatchChunkSize() {
        return this.batchChunkSize;
    }

    public int getBatchUpdatesCorePoolSize() {
        return this.batchUpdatesCorePoolSize;
    }

    public int getBatchUpdatesMaxPoolSize() {
        return this.batchUpdatesMaxPoolSize;
    }

    public int getBatchUpdatesQueueSize() {
        return this.batchUpdatesQueueSize;
    }

    public boolean shouldComputeMetrics() {
        return this.batchComputeMetrics;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public int getBatchUpdatesThrottleLimit() {
        return this.batchUpdatesThrottleLimit;
    }

    public String getIndexingSolrUrl() {
        return this.indexingSolrUrl;
    }

    public boolean explicitCommitsEnabled() {
        return this.explicitCommitsEnabled;
    }

    public int getSolrQueryMaxPageSize() {
        return this.solrQueryMaxPageSize;
    }

    public boolean useMetisProxy() {
        return this.useMetisProxy;
    }

    public String getMetisProxyUrl() {
        return this.metisProxyUrl;
    }

    public String getThumbnailBaseUrl() {
        return this.thumbnailBaseUrl;
    }

    public String getEnrichmentsQueryContentTier() {
        return this.enrichmentsQueryContentTier;
    }

    public String getWikidataBaseUrl() {
        return this.wikidataBaseUrl;
    }

    public int getBatchRemovalsCorePoolSize() {
        return this.batchRemovalsCorePoolSize;
    }

    public int getBatchRemovalsMaxPoolSize() {
        return this.batchRemovalsMaxPoolSize;
    }

    public int getBatchRemovalsQueueSize() {
        return this.batchRemovalsQueueSize;
    }

    public int getBatchRemovalsThrottleLimit() {
        return this.batchRemovalsThrottleLimit;
    }

    public int getMaxFailedTaskRetries() {
        return this.maxFailedTaskRetries;
    }

    public int getEntityIdResponseMaxSize() {
        return this.entityIdResponseMaxSize;
    }

    public String getZohoSyncOwnerFilter() {
        return this.zohoSyncOwnerFilter;
    }

    public int getZohoSyncBatchSize() {
        return this.zohoSyncBatchSize;
    }
}

