/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.europeana.entity.client.exception.EntityClientException;
import eu.europeana.entity.client.utils.EntityApiConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityClientUtils
extends EntityApiConstants {
    private static final Logger LOGGER = LogManager.getLogger(EntityClientUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    private EntityClientUtils() {
    }

    public static URI buildSuggestUrl(String url, String text, String language, String scope, String type, String rows, String algorithm) throws EntityClientException {
        try {
            URIBuilder builder = new URIBuilder(url).addParameter("text", text);
            if (language != null) {
                builder.addParameter("language", language);
            }
            if (scope != null) {
                builder.addParameter("scope", scope);
            }
            if (type != null) {
                builder.addParameter("type", type);
            }
            if (rows != null) {
                builder.addParameter("rows", rows);
            }
            if (algorithm != null) {
                builder.addParameter("algorithm", algorithm);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new EntityClientException("Error creating suggest Urls " + e.getMessage(), 500, e);
        }
    }

    public static URI buildEntityEnrichUrl(String url, String text, String lang, String type, String rows) throws EntityClientException {
        try {
            URIBuilder builder = new URIBuilder(url).addParameter("text", text);
            if (lang != null) {
                builder.addParameter("lang", lang);
            }
            if (type != null) {
                builder.addParameter("type", type);
            }
            if (rows != null) {
                builder.addParameter("rows", rows);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new EntityClientException("Error creating enrich Urls " + e.getMessage(), 500, e);
        }
    }

    public static URI buildEntityResolveUrl(String enityUrl, String resolveUri) throws EntityClientException {
        try {
            URIBuilder builder = new URIBuilder(enityUrl).addParameter("uri", resolveUri);
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new EntityClientException("Error creating resolve Urls " + e.getMessage(), 500, e);
        }
    }

    public static URI buildEntityRetrievalUrl(String path) throws EntityClientException {
        try {
            URIBuilder builder = new URIBuilder(path);
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new EntityClientException("Error creating Entity retrieval Urls " + e.getMessage(), 500, e);
        }
    }

    public static String getEntityRetrievalId(String id) {
        return StringUtils.substringAfter((String)id, (String)"http://data.europeana.eu");
    }

    public static List<String> getEntityApiResults(String json) throws JsonProcessingException {
        ArrayList<String> entities = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)json)) {
            int total;
            ObjectNode node = (ObjectNode)mapper.readValue(json, ObjectNode.class);
            int n = total = node.has("total") ? Integer.parseInt(String.valueOf(node.get("total"))) : 0;
            if (total > 0) {
                if (node.has("items")) {
                    Iterator iterator = node.get("items").iterator();
                    while (iterator.hasNext()) {
                        entities.add(String.valueOf(((JsonNode)iterator.next()).get("id")));
                    }
                }
                if (total != entities.size()) {
                    LOGGER.debug("Mismatch while parsing the suggest results. Entities in suggest Results = {}, Entities collected={}", (Object)total, (Object)entities.size());
                }
            }
        }
        return entities;
    }
}

