/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.connection;

import eu.europeana.api.commons_sb3.auth.AuthenticationHandler;
import eu.europeana.entity.client.connection.BaseApiConnection;
import eu.europeana.entity.client.exception.EntityClientException;
import eu.europeana.entity.client.model.EntityRetrievalResponse;
import eu.europeana.entity.client.utils.EntityClientUtils;
import eu.europeana.entitymanagement.definitions.model.Entity;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ProtocolException;

public class EntityClientApiConnection
extends BaseApiConnection {
    public EntityClientApiConnection(String entityApiUri, String entityManagementApiUri, AuthenticationHandler auth) {
        super(entityApiUri, entityManagementApiUri, auth);
    }

    public List<String> retrieveSuggestions(String text, String language, String scope, String type, String rows, String algorithm) throws EntityClientException {
        try {
            List<String> entities;
            URI suggestUrl = EntityClientUtils.buildSuggestUrl(this.entityApiUri + "/suggest", text, language, scope, type, rows, algorithm);
            SimpleHttpResponse response = this.entityApiConnection.get(suggestUrl.toString(), ContentType.APPLICATION_JSON.getMimeType(), this.auth);
            if (response.getCode() == 200 && (entities = EntityClientUtils.getEntityApiResults(response.getBodyText())) != null) {
                LOGGER.debug("{} entities found for suggest text={}, lang={}, type={}", (Object)entities.size(), (Object)text, (Object)language, (Object)type);
                return entities;
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new EntityClientException("Entity API Client call failed - " + e.getMessage(), 500, e);
        }
        LOGGER.debug("No entity found for suggest text={}, lang={}, type={}", (Object)text, (Object)language, (Object)type);
        return Collections.emptyList();
    }

    public List<String> resolveEntity(String uri) throws EntityClientException {
        try {
            String entityId;
            URI resolveurl = EntityClientUtils.buildEntityResolveUrl(this.entityApiUri + "/resolve", uri);
            SimpleHttpResponse response = this.entityApiConnection.get(resolveurl.toString(), ContentType.APPLICATION_JSON.getMimeType(), this.auth);
            if (response.getCode() == 301 && StringUtils.isEmpty((CharSequence)response.getBodyText()) && StringUtils.isNotEmpty((CharSequence)(entityId = response.getHeader("Location").getValue()))) {
                LOGGER.debug("entity :  {} , found for uri={} ", (Object)entityId, (Object)uri);
                return Collections.singletonList("\"" + entityId + "\"");
            }
        }
        catch (InterruptedException | ExecutionException | ProtocolException e) {
            throw new EntityClientException("Entity API Client call failed - " + e.getMessage(), 500, e);
        }
        LOGGER.debug("No entity found for resolve uri={}", (Object)uri);
        return Collections.emptyList();
    }

    public List<String> retrieveEnrichment(String text, String language, String type, String rows) throws EntityClientException {
        try {
            List<String> entities;
            URI enrichUrl = EntityClientUtils.buildEntityEnrichUrl(this.entityApiUri + "/enrich", text, language, type, rows);
            SimpleHttpResponse response = this.entityApiConnection.get(enrichUrl.toString(), ContentType.APPLICATION_JSON.getMimeType(), this.auth);
            if (response.getCode() == 200 && (entities = EntityClientUtils.getEntityApiResults(response.getBodyText())) != null) {
                LOGGER.debug("{} entities found for enrich text={}, lang={}, type={}", (Object)entities.size(), (Object)text, (Object)language, (Object)type);
                return entities;
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new EntityClientException("Entity API Client call failed - " + e.getMessage(), 500, e);
        }
        LOGGER.debug("No entity found for enrich text={}, lang={}, type={}", (Object)text, (Object)language, (Object)type);
        return Collections.emptyList();
    }

    public Entity getEntityById(String entityId) throws EntityClientException {
        try {
            URI entityUrl = EntityClientUtils.buildEntityRetrievalUrl(this.entityManagementApiUri + EntityClientUtils.getEntityRetrievalId(entityId));
            SimpleHttpResponse response = this.entityManagementConnection.get(entityUrl.toString(), ContentType.APPLICATION_JSON.getMimeType(), this.auth);
            if (response.getCode() == 200) {
                return (Entity)this.mapper.readValue(response.getBodyText(), Entity.class);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new EntityClientException("Entity API Client call failed - " + e.getMessage(), 500, e);
        }
        return null;
    }

    public List<Entity> getEntityByIds(List<String> entityIds) throws EntityClientException {
        try {
            URI entityUrl = EntityClientUtils.buildEntityRetrievalUrl(this.entityManagementApiUri + "/retrieve");
            SimpleHttpResponse response = this.entityManagementConnection.post(entityUrl.toString(), entityIds.toString(), ContentType.APPLICATION_JSON.getMimeType(), this.auth);
            if (response.getCode() == 200) {
                return ((EntityRetrievalResponse)this.mapper.readValue(response.getBodyText(), EntityRetrievalResponse.class)).getItems();
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new EntityClientException("Entity API Client call failed - " + e.getMessage(), 500, e);
        }
        return Collections.emptyList();
    }
}

