/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.connection;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.europeana.api.commons_sb3.auth.AuthenticationHandler;
import eu.europeana.api.commons_sb3.http.AsyncHttpConnection;
import eu.europeana.entity.client.utils.EntityApiConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseApiConnection
extends EntityApiConstants {
    protected static final Logger LOGGER = LogManager.getLogger(BaseApiConnection.class);
    protected static final String ERROR_MESSAGE = "Entity API Client call failed - ";
    protected final AsyncHttpConnection entityApiConnection = new AsyncHttpConnection();
    protected final AsyncHttpConnection entityManagementConnection = new AsyncHttpConnection(true);
    protected final ObjectMapper mapper = new ObjectMapper();
    protected String entityApiUri;
    protected String entityManagementApiUri;
    protected AuthenticationHandler auth;

    public BaseApiConnection(String entityApiUri, String entityManagementApiUri, AuthenticationHandler auth) {
        this.entityApiUri = entityApiUri;
        this.entityManagementApiUri = entityManagementApiUri;
        this.auth = auth;
        SimpleModule module = new SimpleModule();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.registerModule((Module)module);
        this.mapper.findAndRegisterModules();
        this.entityApiConnection.start();
        this.entityManagementConnection.start();
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.auth;
    }

    public void setAuthenticationHandler(AuthenticationHandler auth) {
        this.auth = auth;
    }
}

