/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.config;

import eu.europeana.api.commons_sb3.auth.AuthenticationConfig;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityClientConfiguration
extends AuthenticationConfig {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(EntityClientConfiguration.class);
    public static final String PROPERTIES_FILE = "/entity-client.properties";
    public static final String ENTITY_API_URL = "entity.api.url";
    public static final String ENTITY_MANAGEMENT_URL = "entity.management.url";

    public EntityClientConfiguration() {
        this.loadProperties(PROPERTIES_FILE);
    }

    public EntityClientConfiguration(Properties properties) {
        super(properties);
    }

    private void loadProperties(String propertiesFile) {
        try {
            this.load(((Object)((Object)this)).getClass().getResourceAsStream(propertiesFile));
        }
        catch (IOException e) {
            LOGGER.error("Error loading the properties file {}", (Object)propertiesFile, (Object)e);
        }
    }

    public String getEntityApiUrl() {
        return this.getProperty(ENTITY_API_URL);
    }

    public String getEntityManagementUrl() {
        return this.getProperty(ENTITY_MANAGEMENT_URL);
    }
}

