/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client;

import eu.europeana.api.commons_sb3.auth.AuthenticationHandler;
import eu.europeana.entity.client.BaseEntityApiClient;
import eu.europeana.entity.client.config.EntityClientConfiguration;
import eu.europeana.entity.client.exception.EntityClientException;
import eu.europeana.entity.client.web.EntityApi;
import eu.europeana.entitymanagement.definitions.model.Entity;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class EntityApiClient
extends BaseEntityApiClient
implements EntityApi {
    public EntityApiClient(EntityClientConfiguration configuration) throws EntityClientException {
        super(configuration);
    }

    public EntityApiClient(String entityApiUri, String entityManagementApiUri, AuthenticationHandler auth) throws EntityClientException {
        super(entityApiUri, entityManagementApiUri, auth);
    }

    @Override
    public List<Entity> suggestEntity(String text, String language, String scope, String type, String rows, String algorithm) throws EntityClientException {
        List<String> suggestResults = this.getEntityClientApiConnection().retrieveSuggestions(text, language, scope, type, rows, algorithm);
        return this.getMetadata(suggestResults);
    }

    @Override
    public List<Entity> enrichEntity(String text, String lang, String type, String rows) throws EntityClientException {
        List<String> enrichResults = this.getEntityClientApiConnection().retrieveEnrichment(text, lang, type, rows);
        return this.getMetadata(enrichResults);
    }

    @Override
    public Entity getEntity(String entityId) throws EntityClientException {
        return this.getEntityClientApiConnection().getEntityById(entityId);
    }

    @Override
    public List<Entity> resolveEntity(String uri) throws EntityClientException {
        List<String> resolveResults = this.getEntityClientApiConnection().resolveEntity(uri);
        return this.getMetadata(resolveResults);
    }

    public List<Entity> getMetadata(List<String> results) throws EntityClientException {
        List<Entity> entities = new ArrayList<Entity>();
        if (!results.isEmpty()) {
            if (results.size() == 1) {
                entities.add(this.getEntityClientApiConnection().getEntityById(StringUtils.remove((String)results.get(0), (String)"\"")));
            } else {
                entities = this.getEntityClientApiConnection().getEntityByIds(results);
            }
            if (entities.size() != results.size()) {
                List<String> retrievedEMEntities = entities.stream().map(Entity::getEntityId).toList();
                throw new EntityClientException("Mismatch between entity Api v2 entities =" + String.valueOf(results) + "  and EM entities=" + String.valueOf(retrievedEMEntities));
            }
        }
        return entities;
    }
}

