/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import eu.europeana.entity.client.BaseEntityApiClient;
import eu.europeana.entity.client.config.EntityClientConfiguration;
import eu.europeana.entity.client.exception.TechnicalRuntimeException;
import eu.europeana.entity.client.web.EntityClientApi;
import eu.europeana.entitymanagement.definitions.model.Entity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EntityClientApiImpl
extends BaseEntityApiClient
implements EntityClientApi {
    public EntityClientApiImpl() {
        this(new EntityClientConfiguration());
    }

    public EntityClientApiImpl(EntityClientConfiguration configuration) {
        super(configuration);
    }

    @Override
    public List<Entity> getSuggestions(String text, String language, String scope, String type, String rows, String algorithm) throws JsonProcessingException, TechnicalRuntimeException {
        List<String> suggestResults = this.getEntityApiRestClient().retrieveSuggestions(text, language, scope, type, rows, algorithm);
        return this.getMetadata(suggestResults);
    }

    @Override
    public List<Entity> getEnrichment(String text, String lang, String type, String rows) throws JsonProcessingException {
        List<String> enrichResults = this.getEntityApiRestClient().retrieveEnrichment(text, lang, type, rows);
        return this.getMetadata(enrichResults);
    }

    @Override
    public Entity getEntityById(String entityId) {
        return this.getEntityManagementRestClient().getEntityById(entityId);
    }

    @Override
    public List<Entity> getEntityByUri(String uri) throws TechnicalRuntimeException {
        List<String> resolveResults = this.getEntityApiRestClient().retrieveEntityByUri(uri);
        return this.getMetadata(resolveResults);
    }

    private List<Entity> getMetadata(List<String> results) throws TechnicalRuntimeException {
        List<Entity> entities = new ArrayList<Entity>();
        if (!results.isEmpty()) {
            if (results.size() == 1) {
                entities.add(this.getEntityManagementRestClient().getEntityById(StringUtils.remove((String)results.get(0), (String)"\"")));
            } else {
                entities = this.getEntityManagementRestClient().getEntityByIds(results);
            }
            if (entities.size() != results.size()) {
                List retrievedEMEntities = entities.stream().map(Entity::getEntityId).collect(Collectors.toList());
                throw new TechnicalRuntimeException("Mismatch between entity Api v2 entities =" + results + "  and EM entities=" + retrievedEMEntities);
            }
        }
        return entities;
    }
}

