/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.service;

import eu.europeana.entity.client.exception.MultipleEntityFoundException;
import eu.europeana.entity.client.exception.TechnicalRuntimeException;
import eu.europeana.entity.client.model.EntityRetrievalResponse;
import eu.europeana.entitymanagement.definitions.model.Entity;
import java.net.URI;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class RestClient {
    private static final Logger LOGGER = LogManager.getLogger(RestClient.class);

    public <T> T getEntityId(WebClient webClient, Function<UriBuilder, URI> uriBuilderURIFunction, boolean getLocationHeader) throws TechnicalRuntimeException {
        try {
            WebClient.ResponseSpec result = this.executeGet(webClient, uriBuilderURIFunction);
            if (getLocationHeader) {
                return (T)result.toBodilessEntity().flatMap(voidResponseEntity -> Mono.justOrEmpty((Object)voidResponseEntity.getHeaders().getFirst("location"))).block();
            }
            return (T)result.bodyToMono(String.class).block();
        }
        catch (Exception e) {
            Throwable t = Exceptions.unwrap((Throwable)e);
            if (t instanceof TechnicalRuntimeException) {
                throw new TechnicalRuntimeException("User is not authorised to perform this action");
            }
            if (t instanceof MultipleEntityFoundException) {
                LOGGER.debug("Multiple Entity found - {} ", (Object)e.getMessage());
                return null;
            }
            LOGGER.debug("Entity API Client call failed - {}", (Object)e.getMessage());
            return null;
        }
    }

    public <T> T getEntities(WebClient webClient, Function<UriBuilder, URI> uriBuilderURIFunction, String jsonBody) {
        try {
            if (jsonBody == null) {
                WebClient.ResponseSpec result = this.executeGet(webClient, uriBuilderURIFunction);
                return (T)result.bodyToMono(Entity.class).block();
            }
            WebClient.ResponseSpec result = this.executePost(webClient, uriBuilderURIFunction, jsonBody);
            return (T)result.bodyToMono(EntityRetrievalResponse.class).block();
        }
        catch (Exception e) {
            Throwable t = Exceptions.unwrap((Throwable)e);
            if (t instanceof TechnicalRuntimeException) {
                throw new TechnicalRuntimeException("User is not authorised to perform this action");
            }
            LOGGER.debug("Entity Management Client call failed. {}", (Object)e.getMessage());
            return null;
        }
    }

    private WebClient.ResponseSpec executeGet(WebClient webClient, Function<UriBuilder, URI> uriBuilderURIFunction) throws TechnicalRuntimeException {
        return webClient.get().uri(uriBuilderURIFunction).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().onStatus(arg_0 -> HttpStatus.UNAUTHORIZED.equals(arg_0), response -> response.bodyToMono(String.class).map(TechnicalRuntimeException::new)).onStatus(arg_0 -> HttpStatus.MULTIPLE_CHOICES.equals(arg_0), response -> response.bodyToMono(String.class).map(MultipleEntityFoundException::new));
    }

    private WebClient.ResponseSpec executePost(WebClient webClient, Function<UriBuilder, URI> uriBuilderURIFunction, String jsonBody) throws TechnicalRuntimeException {
        return ((WebClient.RequestBodySpec)webClient.post().uri(uriBuilderURIFunction)).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromValue((Object)jsonBody)).retrieve().onStatus(arg_0 -> HttpStatus.UNAUTHORIZED.equals(arg_0), response -> response.bodyToMono(String.class).map(TechnicalRuntimeException::new));
    }
}

