/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.config;

import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityClientConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(EntityClientConfiguration.class);
    public static final String PROPERTIES_FILE = "/entity-client.properties";
    public static final String API_KEY = "entity.api.key";
    public static final String ENTITY_API_URL = "entity.api.url";
    public static final String ENTITY_MANAGEMENT_URL = "entity.management.url";
    Properties properties;

    public EntityClientConfiguration() {
        this.loadProperties(PROPERTIES_FILE);
    }

    public EntityClientConfiguration(Properties properties) {
        this.properties = properties;
    }

    private Properties loadProperties(String propertiesFile) {
        try {
            this.properties = new Properties();
            this.properties.load(this.getClass().getResourceAsStream(propertiesFile));
        }
        catch (IOException e) {
            LOGGER.error("Error loading the properties file {}", (Object)PROPERTIES_FILE);
        }
        return this.properties;
    }

    public String getApikey() {
        return this.getProperty(API_KEY);
    }

    public String getEntityApiUrl() {
        return this.getProperty(ENTITY_API_URL);
    }

    public String getEntityManagementUrl() {
        return this.getProperty(ENTITY_MANAGEMENT_URL);
    }

    private String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }
}

