/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.europeana.entity.client.utils.EntityApiConstants;
import eu.europeana.entitymanagement.utils.EntityRecordUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.util.UriBuilder;

public class EntityClientUtils
extends EntityApiConstants {
    private static final Logger LOGGER = LogManager.getLogger(EntityClientUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    private EntityClientUtils() {
    }

    public static Function<UriBuilder, URI> buildSuggestUrl(String text, String language, String scope, String type, String rows, String algorithm, String wskey) {
        return uriBuilder -> {
            UriBuilder builder = uriBuilder.path("/suggest").queryParam("wskey", new Object[]{wskey}).queryParam("text", new Object[]{text});
            if (language != null) {
                builder.queryParam("language", new Object[]{language});
            }
            if (scope != null) {
                builder.queryParam("scope", new Object[]{scope});
            }
            if (type != null) {
                builder.queryParam("type", new Object[]{type});
            }
            if (rows != null) {
                builder.queryParam("rows", new Object[]{rows});
            }
            if (algorithm != null) {
                builder.queryParam("algorithm", new Object[]{algorithm});
            }
            return builder.build(new Object[0]);
        };
    }

    public static Function<UriBuilder, URI> buildEntityEnrichUrl(String text, String lang, String type, String rows, String wskey) {
        return uriBuilder -> {
            UriBuilder builder = uriBuilder.path("/enrich").queryParam("wskey", new Object[]{wskey}).queryParam("text", new Object[]{text});
            if (lang != null) {
                builder.queryParam("lang", new Object[]{lang});
            }
            if (type != null) {
                builder.queryParam("type", new Object[]{type});
            }
            if (rows != null) {
                builder.queryParam("rows", new Object[]{rows});
            }
            return builder.build(new Object[0]);
        };
    }

    public static Function<UriBuilder, URI> buildEntityResolveUrl(String uri, String wsKey) {
        return uriBuilder -> {
            UriBuilder builder = uriBuilder.path("/resolve").queryParam("uri", new Object[]{uri}).queryParam("wskey", new Object[]{wsKey});
            return builder.build(new Object[0]);
        };
    }

    public static Function<UriBuilder, URI> buildEntityRetrievalUrl(String id, String wsKey) {
        return uriBuilder -> {
            UriBuilder builder = uriBuilder.path(id).queryParam("wskey", new Object[]{wsKey});
            return builder.build(new Object[0]);
        };
    }

    public static Function<UriBuilder, URI> buildMultipleEntityRetrievalUrl(String wsKey) {
        return uriBuilder -> {
            UriBuilder builder = uriBuilder.path("/retrieve").queryParam("wskey", new Object[]{wsKey});
            return builder.build(new Object[0]);
        };
    }

    public static String getEntityRetrievalId(String id) {
        if (StringUtils.contains((CharSequence)id, (CharSequence)"base")) {
            return StringUtils.substringAfter((String)id, (String)"http://data.europeana.eu");
        }
        return "/" + EntityRecordUtils.getEntityRequestPathWithBase((String)id);
    }

    public static List<String> getEntityApiResults(String json) throws JsonProcessingException {
        ArrayList<String> entities = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)json)) {
            int total;
            ObjectNode node = (ObjectNode)mapper.readValue(json, ObjectNode.class);
            int n = total = node.has("total") ? Integer.parseInt(String.valueOf(node.get("total"))) : 0;
            if (total > 0) {
                if (node.has("items")) {
                    Iterator iterator = node.get("items").iterator();
                    while (iterator.hasNext()) {
                        entities.add(String.valueOf(((JsonNode)iterator.next()).get("id")));
                    }
                }
                if (total != entities.size()) {
                    LOGGER.debug("Mismatch while parsing the suggest results. Entities in suggest Results = {}, Entities collected={}", (Object)total, (Object)entities.size());
                }
            }
        }
        return entities;
    }
}

