/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.entity.client.service;

import eu.europeana.entity.client.exception.TechnicalRuntimeException;
import eu.europeana.entity.client.model.EntityRetrievalResponse;
import eu.europeana.entity.client.service.RestClient;
import eu.europeana.entity.client.utils.EntityClientUtils;
import eu.europeana.entitymanagement.definitions.model.Entity;
import java.util.List;
import org.springframework.web.reactive.function.client.WebClient;

public class EntityManagementRestClient
extends RestClient {
    private final WebClient webClient;
    private final String wskey;

    public EntityManagementRestClient(WebClient webClient, String wskey) {
        this.webClient = webClient;
        this.wskey = wskey;
    }

    public Entity getEntityById(String entityId) throws TechnicalRuntimeException {
        return (Entity)this.getEntities(this.webClient, EntityClientUtils.buildEntityRetrievalUrl(EntityClientUtils.getEntityRetrievalId(entityId), this.wskey), null);
    }

    public List<Entity> getEntityByIds(List<String> entityIds) throws TechnicalRuntimeException {
        EntityRetrievalResponse result = (EntityRetrievalResponse)this.getEntities(this.webClient, EntityClientUtils.buildMultipleEntityRetrievalUrl(this.wskey), entityIds.toString());
        return result.getItems();
    }
}

